/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi.synth;

import io.github.tofodroid.mods.mimi.client.midi.synth.MIMISynthUtils;
import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.github.tofodroid.mods.mimi.util.EntityUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.sound.midi.MidiChannel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MIMIChannel {
    public static final Integer MIDI_CHANNEL_IDLE_SECONDS = 8;
    public static final Integer MAX_NOTE_DIST = 2 * NoteEvent.NOTE_DEF_RANGE;
    protected final MidiChannel channel;
    protected final Integer channelNum;
    protected Instant lastNoteTime;
    protected BlockPos lastNotePos;

    public MIMIChannel(Integer channelNum, MidiChannel channel) {
        this.channelNum = channelNum;
        this.channel = channel;
        this.setVolume(ByteUtils.ZERO);
    }

    public void setInstrument(InstrumentSpec instrument) {
        this.channel.programChange(instrument.midiBankNumber * 128, instrument.midiPatchNumber);
        this.setVolume(ByteUtils.ZERO);
        this.channel.allSoundOff();
        this.channel.resetAllControllers();
    }

    public void clear() {
        this.lastNoteTime = null;
        this.setVolume(ByteUtils.ZERO);
        this.reset();
    }

    public void noteOn(BlockPos notePos) {
        this.lastNoteTime = Instant.now();
        this.lastNotePos = notePos;
    }

    public void reset() {
        if (this.channel != null) {
            this.channel.resetAllControllers();
            this.channel.setPitchBend(8192);
            this.channel.allSoundOff();
        }
    }

    public void setVolume(Byte volume) {
        this.channel.controlChange(7, volume.byteValue());
    }

    public void setLRPan(Byte lrPan) {
        this.channel.controlChange(10, lrPan.byteValue());
    }

    public Boolean tick(Player clientPlayer, Boolean isClientChannel) {
        if (!this.isIdle().booleanValue() && this.lastNotePos != null) {
            double lastNoteDist = Math.abs(Math.sqrt(EntityUtils.getEntityHeadPos((LivingEntity)clientPlayer).distSqr((Vec3i)this.lastNotePos)));
            if (lastNoteDist <= (double)MAX_NOTE_DIST.intValue()) {
                if (!isClientChannel.booleanValue()) {
                    this.channel.controlChange(7, MIMISynthUtils.getVolumeForRelativeNotePosition(clientPlayer.getEyePosition(), this.lastNotePos).byteValue());
                    this.channel.controlChange(10, MIMISynthUtils.getLRPanForRelativeNotePosition(clientPlayer.getEyePosition(), this.lastNotePos, Float.valueOf(clientPlayer.getYHeadRot())).byteValue());
                } else {
                    this.channel.controlChange(7, MIMISynthUtils.getVolumeForRelativeNoteDistance(0.0).byteValue());
                    this.channel.controlChange(10, 63);
                }
                return true;
            }
            this.channel.allNotesOff();
        }
        return false;
    }

    public Integer getChannelNumber() {
        return this.channelNum;
    }

    protected Boolean isIdle() {
        if (this.lastNoteTime != null) {
            return Math.abs(ChronoUnit.SECONDS.between(Instant.now(), this.lastNoteTime)) > (long)MIDI_CHANNEL_IDLE_SECONDS.intValue();
        }
        return true;
    }
}

