/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi.synth;

import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public abstract class MIMISynthUtils {
    public static Byte getVolumeForRelativeNotePosition(Vec3 playerPos, BlockPos notePos) {
        Vec3 notePosReal = new Vec3((double)notePos.getX() + 0.5, (double)notePos.getY() + 0.5, (double)notePos.getZ() + 0.5);
        return MIMISynthUtils.getVolumeForRelativeNoteDistance(MIMISynthUtils.distanceBetween(playerPos, notePosReal));
    }

    public static Byte getVolumeForRelativeNoteDistance(Double distance) {
        return MIMISynthUtils.getVelocityForRelativeNoteDistance(distance, true);
    }

    public static Byte getVelocityForRelativeNoteDistance(Double distance, Boolean applyGameVolume) {
        Double volume = 127.0;
        if (distance > 0.0) {
            volume = volume - Math.floor(127.0 * Math.pow(distance, 2.5) / (Math.pow(distance, 2.5) + Math.pow(64.0 - distance, 2.5)));
        }
        if (applyGameVolume.booleanValue()) {
            Double mimiVolume = Double.valueOf(ConfigProxy.getAudioDeviceVolume().intValue()) / 10.0;
            volume = volume * mimiVolume;
            Float catVolume = Float.valueOf(Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.RECORDS));
            catVolume = Float.valueOf(Math.min(Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MASTER), catVolume.floatValue()));
            volume = volume * catVolume.doubleValue();
        }
        volume = volume < 0.0 ? 0.0 : (volume > 127.0 ? 127.0 : volume);
        Byte byteVal = Integer.valueOf(volume.intValue()).byteValue();
        return byteVal;
    }

    public static Byte getLRPanForRelativeNotePosition(Vec3 playerPos, BlockPos notePos, Float playerHeadRoationYaw) {
        Vec3 notePosReal = new Vec3((double)notePos.getX() + 0.5, playerPos.y(), (double)notePos.getZ() + 0.5);
        Double distance2D = MIMISynthUtils.distanceBetween(playerPos, notePosReal);
        Double distanceMult = Math.max(0.0, Math.min(0.5, distance2D / 64.0));
        Double posAngle = MIMISynthUtils.angleBetween(playerPos, notePosReal);
        Double headAngle = (playerHeadRoationYaw.doubleValue() < 0.0 ? playerHeadRoationYaw.doubleValue() + 360.0 : playerHeadRoationYaw.doubleValue()) % 360.0;
        Double relativeVal = 64.0 * Math.sin(Math.toRadians((posAngle - headAngle + 630.0) % 360.0));
        relativeVal = relativeVal * (distance2D <= 1.0 ? 0.0 : (distance2D <= 2.0 ? 0.25 : 0.5) + distanceMult);
        Integer lrPan = 63 + relativeVal.intValue();
        lrPan = lrPan < 0 ? 0 : (lrPan > 127 ? 127 : lrPan);
        Byte byteVal = lrPan.byteValue();
        return byteVal;
    }

    public static Double distanceBetween(Vec3 source, Vec3 target) {
        return Math.sqrt(source.distanceToSqr(target));
    }

    public static Double angleBetween(Vec3 source, Vec3 target) {
        Double angle = Math.toDegrees(Math.atan2(target.z() - source.z(), target.x() - source.x()));
        return (angle < 0.0 ? angle + 360.0 : angle) % 360.0;
    }
}

