/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.api.event;

import javax.sound.midi.ShortMessage;

public enum MidiEventType {
    NOTE_ON,
    NOTE_OFF,
    CONTROL,
    RESET,
    PITCH_BEND,
    OTHER,
    UNKNOWN;


    public Byte toByte() {
        return MidiEventType.toByte(this);
    }

    public static Byte toByte(MidiEventType val) {
        return (byte)val.ordinal();
    }

    public static MidiEventType fromByte(Byte val) {
        MidiEventType[] values = MidiEventType.values();
        if (val >= 0 && val < values.length) {
            return values[val];
        }
        return UNKNOWN;
    }

    public static MidiEventType fromShortMessage(ShortMessage message) {
        if (MidiEventType.isNoteOffMessage(message).booleanValue()) {
            return NOTE_OFF;
        }
        if (MidiEventType.isNoteOnMessage(message).booleanValue()) {
            return NOTE_ON;
        }
        if (MidiEventType.isSupportedControlMessage(message).booleanValue()) {
            return CONTROL;
        }
        if (MidiEventType.isPitchBendMessage(message).booleanValue()) {
            return PITCH_BEND;
        }
        return OTHER;
    }

    protected static Boolean isNoteOnMessage(ShortMessage msg) {
        return msg.getData1() >= 0 && 144 == msg.getCommand() && msg.getData2() > 0;
    }

    protected static Boolean isNoteOffMessage(ShortMessage msg) {
        return msg.getData1() >= 0 && (128 == msg.getCommand() || 144 == msg.getCommand() && msg.getData2() == 0);
    }

    protected static Boolean isSupportedControlMessage(ShortMessage msg) {
        return 176 == msg.getCommand() && (msg.getData1() == 1 || msg.getData1() == 2 || msg.getData1() == 4 || msg.getData1() == 120 || msg.getData1() == 121 || msg.getData1() == 123 || msg.getData1() >= 64 && msg.getData1() <= 69 || msg.getData1() == 84 || msg.getData1() >= 91 && msg.getData1() <= 95);
    }

    protected static Boolean isPitchBendMessage(ShortMessage msg) {
        return 224 == msg.getCommand();
    }
}

