/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.api.event.broadcast;

import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public interface IBroadcastConsumer
extends AutoCloseable {
    public static final Byte ALL_CHANNELS_ID = 127;

    default public Boolean isEventInRange(BroadcastEvent event) {
        return event.dimension.equals(this.getConsumeDimension()) && (event.range < 0 || Math.floor(Math.abs(Math.sqrt(event.pos.distSqr((Vec3i)this.getConsumePos())))) <= (double)event.range.intValue());
    }

    public UUID getLinkedId();

    public UUID getOwnerId();

    public List<Byte> getEnabledChannelsList();

    public BlockPos getConsumePos();

    public ResourceKey<Level> getConsumeDimension();

    public void tickConsumer();

    public void onConsumerRemoved();

    default public void consumeEvent(BroadcastEvent message) {
        if (this.willHandleEvent(message).booleanValue() && this.isEventInRange(message).booleanValue()) {
            this.doHandleEvent(message);
        }
    }

    public Boolean willHandleEvent(BroadcastEvent var1);

    public void doHandleEvent(BroadcastEvent var1);
}

