/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AColoredBlock
extends Block {
    public static final IntegerProperty DYE_ID = IntegerProperty.create((String)"dye_id", (int)0, (int)15);

    public AColoredBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Integer dyeId = TagUtils.getIntOrDefault((DataComponentHolder)context.getItemInHand(), DYE_ID.getName(), 0);
        if (dyeId < 0 || dyeId > 15) {
            dyeId = 0;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)DYE_ID, (Comparable)dyeId);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            ItemStack itemstack = this.getCloneItemStack((LevelReader)level, pos, state);
            level.addFreshEntity((Entity)this.getItemEntity(level, pos, itemstack));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected ItemEntity getItemEntity(Level level, BlockPos pos, ItemStack itemstack) {
        ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
        itementity.setDefaultPickUpDelay();
        return itementity;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        this.appendSettingsTooltip(stack, tooltip);
    }

    public ItemStack getCloneItemStack(LevelReader reader, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.getCloneItemStack(reader, pos, state);
        TagUtils.setOrRemoveInt(itemstack, DYE_ID.getName(), state.getOptionalValue((Property)DYE_ID).orElse(0));
        return itemstack;
    }

    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"Dyed:").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.literal((String)("  " + DyeColor.byId((int)TagUtils.getIntOrDefault((DataComponentHolder)blockItemStack, DYE_ID.getName(), 0)).name())).withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
    }

    public static final Integer getDecimalColorFromState(BlockState state) {
        Optional dyeId = state.getOptionalValue((Property)DYE_ID);
        if (dyeId.isPresent()) {
            return DyeColor.byId((int)((Integer)dyeId.get())).getFireworkColor();
        }
        return DyeColor.WHITE.getFireworkColor();
    }
}

