/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.common.tile.AContainerTile;
import io.github.tofodroid.mods.mimi.common.tile.AStaticInventoryTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AContainerBlock<T extends BlockEntity>
extends BaseEntityBlock {
    protected AContainerBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
            return;
        }
        this.dropContent(worldIn, pos, worldIn.getBlockEntity(pos));
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        T tile;
        if (!worldIn.isClientSide && (tile = this.getTileForBlock(worldIn, pos)) != null) {
            player.openMenu(this.getMenuProvider(state, worldIn, pos));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.getTileType().create(pos, state);
    }

    public abstract BlockEntityType<T> getTileType();

    public void writeGuiFriendlyByteBuf(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, FriendlyByteBuf buffer) {
        buffer.writeBlockPos(pos);
    }

    public void dropContent(Level worldIn, BlockPos pos, BlockEntity blockEntity) {
        if (blockEntity instanceof AContainerTile) {
            ((AContainerTile)blockEntity).dropContent();
            worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
        } else if (blockEntity instanceof AStaticInventoryTile) {
            ((AStaticInventoryTile)blockEntity).dropContent();
            worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
        }
    }

    public T getTileForBlock(Level worldIn, BlockPos pos) {
        BlockEntity entity = worldIn.getBlockEntity(pos);
        return (T)(entity != null && entity instanceof BlockEntity && entity instanceof Container ? entity : null);
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }
}

