/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import com.mojang.serialization.MapCodec;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileConductor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockConductor
extends AConfigurableTileBlock<TileConductor> {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    public static final String REGISTRY_NAME = "conductor";
    public static final MapCodec<BlockConductor> CODEC = BlockConductor.simpleCodec(BlockConductor::new);

    public MapCodec<BlockConductor> codec() {
        return CODEC;
    }

    public BlockConductor(BlockBehaviour.Properties props) {
        super(props.explosionResistance(6.0f).strength(2.0f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_55659_) {
        return (BlockState)this.defaultBlockState().setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(p_55659_.getLevel().hasNeighborSignal(p_55659_.getClickedPos())));
    }

    @Override
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.isClientSide) {
            if (!state.hasBlockEntity()) {
                return;
            }
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof TileConductor) {
                ((TileConductor)blockEntity).stopNote();
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, BlockPos neighborPos, boolean flag1) {
        boolean wasTriggered;
        if (!level.isClientSide && (wasTriggered = ((Boolean)blockState.getValue((Property)TRIGGERED)).booleanValue()) != level.hasNeighborSignal(blockPos)) {
            if (wasTriggered) {
                ((TileConductor)((Object)this.getTileForBlock(level, blockPos))).stopNote();
            } else {
                ((TileConductor)((Object)this.getTileForBlock(level, blockPos))).startNote();
                level.scheduleTick(blockPos, (Block)this, 4);
            }
            level.setBlock(blockPos, (BlockState)blockState.cycle((Property)TRIGGERED), 2);
        }
    }

    public void tick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TRIGGERED});
    }

    @Override
    public AConfigurableTileBlock.OpenGuiWrapper openGuiWrapper() {
        return (level, player, tilePos, handIn, itemStack) -> player.sendSystemMessage((Component)Component.translatableWithFallback((String)"block.mimi.conductor.wip", (String)"Coming soon!"));
    }

    @Override
    public BlockEntityType<TileConductor> getTileType() {
        return ModTiles.CONDUCTOR;
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatableWithFallback((String)"block.mimi.conductor.wip", (String)"Coming soon!"));
    }
}

