/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import com.mojang.serialization.MapCodec;
import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileEffectEmitter;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockEffectEmitter
extends AConfigurableTileBlock<TileEffectEmitter> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty INVERTED = BlockStateProperties.INVERTED;
    public static final String REGISTRY_NAME = "effectemitter";
    public static final MapCodec<BlockEffectEmitter> CODEC = BlockEffectEmitter.simpleCodec(BlockEffectEmitter::new);

    public MapCodec<BlockEffectEmitter> codec() {
        return CODEC;
    }

    public BlockEffectEmitter(BlockBehaviour.Properties props) {
        super(props.explosionResistance(6.0f).strength(2.0f).sound(SoundType.COPPER));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)INVERTED, (Comparable)TagUtils.getBooleanOrDefault((DataComponentHolder)context.getItemInHand(), "invert_signal", false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    @Override
    public BlockEntityType<TileEffectEmitter> getTileType() {
        return ModTiles.EFFECTEMITTER;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{POWERED}).add(new Property[]{INVERTED});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockEffectEmitter.createTickerHelper(type, this.getTileType(), TileEffectEmitter::doTick);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Boolean wasPowered;
        if (!worldIn.isClientSide && (wasPowered = (Boolean)state.getValue((Property)POWERED)).booleanValue() != worldIn.hasNeighborSignal(pos)) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    @Override
    public AConfigurableTileBlock.OpenGuiWrapper openGuiWrapper() {
        return ClientGuiWrapper::openEffectEmitterGui;
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"Effect Settings:").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.literal((String)"Inverted:").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.literal((String)("  " + (TagUtils.getBooleanOrDefault((DataComponentHolder)blockItemStack, "invert_signal", false) != false ? "Yes" : "No"))).withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.literal((String)"Sound:").withStyle(ChatFormatting.GREEN));
        String soundResource = TagUtils.getStringOrDefault((DataComponentHolder)blockItemStack, "sound", "");
        if (soundResource.isBlank()) {
            tooltip.add((Component)Component.literal((String)"  None").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.literal((String)("  ID: " + soundResource)).withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.literal((String)("  Volume: " + TagUtils.getByteOrDefault(blockItemStack, "volume", 5))).withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.literal((String)("  Pitch: " + TagUtils.getByteOrDefault(blockItemStack, "pitch", 0))).withStyle(ChatFormatting.GREEN));
            Integer loop = TagUtils.getIntOrDefault((DataComponentHolder)blockItemStack, "sound_loop", 0);
            tooltip.add((Component)Component.literal((String)(loop == 0 ? "  Loop: None" : "  Loop: Every " + loop + " ticks")).withStyle(ChatFormatting.GREEN));
        }
        tooltip.add((Component)Component.literal((String)"Particle:").withStyle(ChatFormatting.GREEN));
        String particleResource = TagUtils.getStringOrDefault((DataComponentHolder)blockItemStack, "particle", "");
        if (particleResource.isBlank()) {
            tooltip.add((Component)Component.literal((String)"  None").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.literal((String)("  ID: " + particleResource)).withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.literal((String)("  Side: " + BlockEffectEmitter.getSideFromByte(TagUtils.getByteOrDefault(blockItemStack, "side", 0)))).withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.literal((String)"  Speed: ").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.literal((String)("    X: " + TagUtils.getByteOrDefault(blockItemStack, "speed_x", 0) + ", Y: " + TagUtils.getByteOrDefault(blockItemStack, "speed_y", 0) + ", Z: " + TagUtils.getByteOrDefault(blockItemStack, "speed_z", 0))).withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.literal((String)("  Area: " + TagUtils.getByteOrDefault(blockItemStack, "spread", 0))).withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.literal((String)("  Num: " + TagUtils.getByteOrDefault(blockItemStack, "count", 0))).withStyle(ChatFormatting.GREEN));
            Integer loop = TagUtils.getIntOrDefault((DataComponentHolder)blockItemStack, "particle_loop", 0);
            tooltip.add((Component)Component.literal((String)(loop == 0 ? "  Loop: None" : "  Loop: Every " + loop + " ticks")).withStyle(ChatFormatting.GREEN));
        }
    }

    public static String getSideFromByte(Byte side) {
        switch (side) {
            default: {
                return "Top";
            }
            case 1: {
                return "Bottom";
            }
            case 2: {
                return "North";
            }
            case 3: {
                return "East";
            }
            case 4: {
                return "South";
            }
            case 5: 
        }
        return "West";
    }

    public static ItemStack copyEffectEmitterSettings(ItemStack source, ItemStack target) {
        if (!source.isEmpty() && !target.isEmpty()) {
            ItemStack result = target.copyWithCount(1);
            TagUtils.setOrRemoveString(result, "sound", TagUtils.getStringOrDefault((DataComponentHolder)source, "sound", ""));
            TagUtils.setOrRemoveString(result, "particle", TagUtils.getStringOrDefault((DataComponentHolder)source, "particle", ""));
            TagUtils.setOrRemoveByte(result, "volume", TagUtils.getByteOrDefault(source, "volume", 5));
            TagUtils.setOrRemoveByte(result, "pitch", TagUtils.getByteOrDefault(source, "pitch", 0));
            TagUtils.setOrRemoveByte(result, "side", TagUtils.getByteOrDefault(source, "side", 0));
            TagUtils.setOrRemoveByte(result, "spread", TagUtils.getByteOrDefault(source, "spread", 0));
            TagUtils.setOrRemoveByte(result, "count", TagUtils.getByteOrDefault(source, "count", 1));
            TagUtils.setOrRemoveByte(result, "speed_x", TagUtils.getByteOrDefault(source, "speed_x", 0));
            TagUtils.setOrRemoveByte(result, "speed_y", TagUtils.getByteOrDefault(source, "speed_y", 0));
            TagUtils.setOrRemoveByte(result, "speed_z", TagUtils.getByteOrDefault(source, "speed_z", 0));
            TagUtils.setOrRemoveInt(result, "sound_loop", TagUtils.getIntOrDefault((DataComponentHolder)source, "sound_loop", 0));
            TagUtils.setOrRemoveInt(result, "particle_loop", TagUtils.getIntOrDefault((DataComponentHolder)source, "particle_loop", 0));
            TagUtils.setOrRemoveBoolean(result, "invert_signal", TagUtils.getBooleanOrDefault((DataComponentHolder)source, "invert_signal", false));
            return result;
        }
        return target;
    }
}

