/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentConfig;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.common.entity.EntitySeat;
import io.github.tofodroid.mods.mimi.common.entity.ModEntities;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.VoxelShapeUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockInstrument
extends AConfigurableTileBlock<TileInstrument>
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<BlockInstrument> CODEC = BlockInstrument.instrumentCodec(BlockInstrument::new);
    protected final Map<Direction, VoxelShape> SHAPES;
    protected final Byte instrumentId;
    protected final Integer defaultChannels;
    protected final Integer defaultColor;
    protected final String REGISTRY_NAME;

    public MapCodec<BlockInstrument> codec() {
        return CODEC;
    }

    public BlockInstrument(BlockBehaviour.Properties props, Byte instrumentId) {
        this(props, InstrumentConfig.getBydId(instrumentId));
    }

    public BlockInstrument(BlockBehaviour.Properties props, InstrumentSpec spec) {
        super(props.explosionResistance(6.0f).strength(2.0f).sound(SoundType.WOOD).dynamicShape().noOcclusion());
        this.SHAPES = this.generateShapes(VoxelShapeUtils.loadFromStrings(spec.collisionShapes));
        this.REGISTRY_NAME = spec.registryName;
        this.defaultChannels = MidiNbtDataUtils.getDefaultChannelsForBank(spec.midiBankNumber);
        this.instrumentId = spec.instrumentId;
        this.defaultColor = spec.defaultColor();
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static MapCodec<BlockInstrument> instrumentCodec(BiFunction<BlockBehaviour.Properties, Byte, BlockInstrument> p_312290_) {
        return RecordCodecBuilder.mapCodec(p_309873_ -> p_309873_.group((App)BlockInstrument.propertiesCodec(), (App)Codec.BYTE.fieldOf("instrumentId").forGetter(BlockInstrument::getInstrumentId)).apply((Applicative)p_309873_, p_312290_));
    }

    protected Map<Direction, VoxelShape> generateShapes(VoxelShape shape) {
        return VoxelShapeUtils.generateFacingShape(shape);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        TileInstrument tileInstrument = (TileInstrument)((Object)this.getTileForBlock(worldIn, pos));
        if (tileInstrument != null) {
            if (!worldIn.isClientSide) {
                if (player.getVehicle() == null) {
                    tileInstrument.attemptSit(player);
                    return InteractionResult.CONSUME;
                }
            } else if (((Object)((Object)tileInstrument)).equals((Object)BlockInstrument.getTileInstrumentForEntity((LivingEntity)player))) {
                this.openGuiWrapper().accept(worldIn, player, null, null, tileInstrument.getSourceStack());
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    @Override
    public BlockEntityType<TileInstrument> getTileType() {
        return ModTiles.INSTRUMENT;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{DIRECTION, WATERLOGGED});
    }

    @Override
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)direction)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.SHAPES.get(state.getValue((Property)DIRECTION));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.setValue((Property)DIRECTION, (Comparable)rotation.rotate((Direction)state.getValue((Property)DIRECTION)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)DIRECTION)));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        TileInstrument tile = (TileInstrument)super.newBlockEntity(pos, state);
        return tile;
    }

    public String getRegistryName() {
        return this.REGISTRY_NAME;
    }

    public Integer getDefaultColor() {
        return this.defaultColor;
    }

    public Byte getInstrumentId() {
        return this.instrumentId;
    }

    public Integer getDefaultChannels() {
        return this.defaultChannels;
    }

    public static Boolean isEntitySittingAtInstrument(LivingEntity entity) {
        return entity.isPassenger() && entity.getVehicle() != null && ModEntities.SEAT.equals((Object)entity.getVehicle().getType());
    }

    public static EntitySeat getSeatForEntity(LivingEntity entity) {
        if (BlockInstrument.isEntitySittingAtInstrument(entity).booleanValue()) {
            return (EntitySeat)entity.getVehicle();
        }
        return null;
    }

    public static ItemStack getTileInstrumentStackForEntity(LivingEntity entity) {
        TileInstrument tile = BlockInstrument.getTileInstrumentForEntity(entity);
        if (tile != null) {
            return tile.getSourceStack();
        }
        return null;
    }

    public static TileInstrument getTileInstrumentForEntity(LivingEntity entity) {
        BlockPos pos;
        if (entity.isAlive() && BlockInstrument.isEntitySittingAtInstrument(entity).booleanValue() && (pos = BlockInstrument.getSeatForEntity(entity).getSource()) != null && Level.isInSpawnableBounds((BlockPos)pos)) {
            BlockEntity sourceEntity = entity.level().getBlockEntity(BlockInstrument.getSeatForEntity(entity).getSource());
            return sourceEntity != null && sourceEntity instanceof TileInstrument ? (TileInstrument)sourceEntity : null;
        }
        return null;
    }

    @Override
    public AConfigurableTileBlock.OpenGuiWrapper openGuiWrapper() {
        return ClientGuiWrapper::openInstrumentGui;
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
    }
}

