/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.common.block.AColoredBlock;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockLedCube
extends AColoredBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty INVERTED = BlockStateProperties.INVERTED;
    public static final String REGISTRY_NAME_A = "ledcube_a";
    public static final String REGISTRY_NAME_B = "ledcube_b";
    public static final String REGISTRY_NAME_C = "ledcube_c";
    public static final String REGISTRY_NAME_D = "ledcube_d";
    public static final String REGISTRY_NAME_E = "ledcube_e";
    public static final String REGISTRY_NAME_F = "ledcube_f";
    public static final String REGISTRY_NAME_G = "ledcube_g";
    public static final String REGISTRY_NAME_H = "ledcube_h";

    public BlockLedCube() {
        super(BlockBehaviour.Properties.of().explosionResistance(6.0f).strength(2.0f).sound(SoundType.LANTERN).hasPostProcess((a, b, c) -> true).emissiveRendering((a, b, c) -> BlockLedCube.isLit(a)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)INVERTED, (Comparable)Boolean.valueOf(false))).setValue((Property)DYE_ID, (Comparable)Integer.valueOf(0)));
    }

    public static Boolean isLit(BlockState state) {
        return state.getValue((Property)INVERTED) != state.getValue((Property)POWERED);
    }

    public float getShadeBrightness(BlockState state, BlockGetter p_153690_, BlockPos p_153691_) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 1.0f : super.getShadeBrightness(state, p_153690_, p_153691_);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (Items.REDSTONE_TORCH.equals(player.getItemInHand(handIn).getItem()) || Items.REDSTONE_BLOCK.equals(player.getItemInHand(handIn).getItem())) {
            if (!worldIn.isClientSide) {
                worldIn.setBlock(pos, (BlockState)state.cycle((Property)INVERTED), 2);
                worldIn.playSound(null, pos, SoundEvents.LANTERN_HIT, SoundSource.BLOCKS);
            }
            return ItemInteractionResult.CONSUME;
        }
        if (player.getItemInHand(handIn).isEmpty()) {
            if (!worldIn.isClientSide) {
                Integer dyeId = (Integer)state.getValue((Property)DYE_ID);
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)DYE_ID, (Comparable)Integer.valueOf(dyeId < 15 ? dyeId + 1 : 0)), 2);
                worldIn.playSound(null, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.get(), SoundSource.BLOCKS);
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public int getLightBlock(BlockState state, BlockGetter p_60586_, BlockPos p_60587_) {
        return BlockLedCube.isLit(state) != false ? 15 : super.getLightBlock(state, p_60586_, p_60587_);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())))).setValue((Property)INVERTED, (Comparable)TagUtils.getBooleanOrDefault((DataComponentHolder)context.getItemInHand(), INVERTED.getName(), false));
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        super.appendSettingsTooltip(blockItemStack, tooltip);
        tooltip.add((Component)Component.literal((String)"Inverted:").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.literal((String)("  " + (TagUtils.getBooleanOrDefault((DataComponentHolder)blockItemStack, INVERTED.getName(), false) != false ? "Yes" : "No"))).withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader reader, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.getCloneItemStack(reader, pos, state);
        itemstack.set(TagUtils.getBoolComponent(INVERTED.getName()), (Object)state.getOptionalValue((Property)INVERTED).orElse(false));
        return itemstack;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{POWERED});
        state.add(new Property[]{INVERTED});
        state.add(new Property[]{DYE_ID});
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !worldIn.hasNeighborSignal(pos)) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public boolean isSignalSource(BlockState p_60571_) {
        return false;
    }

    public int getSignal(BlockState p_60483_, BlockGetter p_60484_, BlockPos p_60485_, Direction p_60486_) {
        return 0;
    }

    public boolean hasAnalogOutputSignal(BlockState p_60457_) {
        return false;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Boolean wasPowered;
        if (!worldIn.isClientSide && (wasPowered = (Boolean)state.getValue((Property)POWERED)).booleanValue() != worldIn.hasNeighborSignal(pos)) {
            if (wasPowered.booleanValue()) {
                worldIn.scheduleTick(pos, (Block)this, 1);
            } else {
                worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            }
        }
    }
}

