/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import com.mojang.serialization.MapCodec;
import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableMidiPowerSourceBlock;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileListener;
import io.github.tofodroid.mods.mimi.server.events.note.consumer.ServerNoteConsumerManager;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockListener
extends AConfigurableMidiPowerSourceBlock<TileListener> {
    public static final String REGISTRY_NAME = "listener";
    public static final MapCodec<BlockListener> CODEC = BlockListener.simpleCodec(BlockListener::new);

    public MapCodec<BlockListener> codec() {
        return CODEC;
    }

    public BlockListener(BlockBehaviour.Properties props) {
        super(props.explosionResistance(6.0f).strength(2.0f).sound(SoundType.WOOD).isRedstoneConductor((a, b, c) -> false));
    }

    @Override
    public AConfigurableTileBlock.OpenGuiWrapper openGuiWrapper() {
        return ClientGuiWrapper::openListenerGui;
    }

    @Override
    public BlockEntityType<TileListener> getTileType() {
        return ModTiles.LISTENER;
    }

    @Override
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.isClientSide) {
            if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
                return;
            }
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof TileListener) {
                ServerNoteConsumerManager.removeConsumers(((TileListener)blockEntity).getUUID());
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"MIDI Settings:").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        MidiNbtDataUtils.appendInvertSignalTooltip(blockItemStack, tooltip);
        MidiNbtDataUtils.appendFilterInstrumentTooltip(blockItemStack, tooltip);
        MidiNbtDataUtils.appendFilterNoteTooltip(blockItemStack, tooltip);
    }
}

