/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import com.mojang.serialization.MapCodec;
import io.github.tofodroid.mods.mimi.common.block.AContainerBlock;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileMechanicalMaestro;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockMechanicalMaestro
extends AContainerBlock<TileMechanicalMaestro> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final String REGISTRY_NAME = "mechanicalmaestro";
    public static final MapCodec<BlockMechanicalMaestro> CODEC = BlockMechanicalMaestro.simpleCodec(BlockMechanicalMaestro::new);

    public MapCodec<BlockMechanicalMaestro> codec() {
        return CODEC;
    }

    public BlockMechanicalMaestro(BlockBehaviour.Properties props) {
        super(props.explosionResistance(6.0f).strength(2.0f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    @Override
    public BlockEntityType<TileMechanicalMaestro> getTileType() {
        return ModTiles.MECHANICALMAESTRO;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{POWERED});
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isClientSide) {
            TileMechanicalMaestro tile = (TileMechanicalMaestro)((Object)this.getTileForBlock((Level)worldIn, pos));
            Boolean shouldBePowered = worldIn.hasNeighborSignal(pos);
            if (state.getValue((Property)POWERED) != shouldBePowered) {
                worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                if (tile != null) {
                    if (!shouldBePowered.booleanValue()) {
                        tile.reset();
                    }
                    tile.refreshMidiReceivers();
                }
            }
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Boolean wasPowered;
        if (!worldIn.isClientSide && (wasPowered = (Boolean)state.getValue((Property)POWERED)).booleanValue() != worldIn.hasNeighborSignal(pos)) {
            worldIn.scheduleTick(pos, (Block)this, 4);
        }
    }

    @Override
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.isClientSide) {
            if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
                return;
            }
            TileMechanicalMaestro tile = (TileMechanicalMaestro)((Object)this.getTileForBlock(worldIn, pos));
            if (tile != null) {
                BroadcastManager.removeOwnedBroadcastConsumers(tile.getUUID());
                tile.reset();
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }
}

