/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import com.mojang.serialization.MapCodec;
import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableNoteResponsiveTileBlock;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileReceiver;
import io.github.tofodroid.mods.mimi.common.tile.TileRelay;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockRelay
extends AConfigurableNoteResponsiveTileBlock<TileRelay> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final String REGISTRY_NAME = "relay";
    public static final MapCodec<BlockRelay> CODEC = BlockRelay.simpleCodec(BlockRelay::new);

    public MapCodec<BlockRelay> codec() {
        return CODEC;
    }

    public BlockRelay(BlockBehaviour.Properties props) {
        super(props.explosionResistance(6.0f).strength(2.0f).sound(SoundType.METAL).isRedstoneConductor((a, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{POWERED});
    }

    @Override
    public AConfigurableTileBlock.OpenGuiWrapper openGuiWrapper() {
        return ClientGuiWrapper::openRelayGui;
    }

    @Override
    public BlockEntityType<TileRelay> getTileType() {
        return ModTiles.RELAY;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        TileRelay tile;
        if ((stack.getItem() instanceof IInstrumentItem || stack.getItem().equals(ModItems.RECEIVER) || stack.getItem().equals(ModItems.RELAY) || stack.getItem().equals((Object)ModItems.SOURCELINKER)) && (tile = (TileRelay)this.getTileForBlock(level, pos)) != null && player.isCrouching()) {
            if (!level.isClientSide) {
                String transmitterName = level.dimension().location().getPath() + "@(" + pos.toShortString() + ")";
                MidiNbtDataUtils.setMidiSourceFromRelay(stack, tile.getUUID(), transmitterName);
                player.setItemInHand(player.getUsedItemHand(), stack);
                MutableComponent message = Component.literal((String)"Linked ").append(stack.getHoverName()).append((Component)Component.literal((String)" to ")).append((Component)this.getName());
                player.displayClientMessage((Component)message, true);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.isClientSide) {
            if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
                return;
            }
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof TileReceiver) {
                BroadcastManager.removeOwnedBroadcastConsumers(((TileReceiver)blockEntity).getUUID());
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"MIDI Settings:").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        MidiNbtDataUtils.appendBroadcastRangeTooltip(blockItemStack, tooltip);
        MidiNbtDataUtils.appendMidiChannelMappingsTooltip(blockItemStack, tooltip);
        MidiNbtDataUtils.appendMidiSourceTooltip(blockItemStack, tooltip);
    }
}

