/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import com.mojang.serialization.MapCodec;
import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AContainerBlock;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileTransmitter;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.ServerTransmitterManager;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;

public class BlockTransmitter
extends AContainerBlock<TileTransmitter> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final String REGISTRY_NAME = "transmitterblock";
    public static final MapCodec<BlockTransmitter> CODEC = BlockTransmitter.simpleCodec(BlockTransmitter::new);

    public MapCodec<BlockTransmitter> codec() {
        return CODEC;
    }

    public BlockTransmitter(BlockBehaviour.Properties props) {
        super(props.explosionResistance(6.0f).strength(2.0f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        TileTransmitter tile;
        if ((stack.getItem() instanceof IInstrumentItem || stack.getItem().equals(ModItems.RECEIVER) || stack.getItem().equals(ModItems.RELAY) || stack.getItem().equals((Object)ModItems.SOURCELINKER)) && (tile = (TileTransmitter)((Object)this.getTileForBlock(level, pos))) != null && player.isCrouching()) {
            if (!level.isClientSide) {
                String transmitterName = level.dimension().location().getPath() + "@(" + pos.toShortString() + ")";
                MidiNbtDataUtils.setMidiSourceFromTransmitter(stack, tile.getUUID(), transmitterName);
                player.setItemInHand(player.getUsedItemHand(), stack);
                MutableComponent message = Component.literal((String)"Linked ").append(stack.getHoverName()).append((Component)Component.literal((String)" to ")).append((Component)this.getName());
                player.displayClientMessage((Component)message, true);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        TileTransmitter tile = (TileTransmitter)((Object)this.getTileForBlock(worldIn, pos));
        if (tile != null && worldIn.isClientSide) {
            ClientGuiWrapper.openTransmitterBlockGui(worldIn, tile.getUUID());
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{POWERED});
    }

    @Override
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
            return;
        }
        TileTransmitter tileEntity = (TileTransmitter)((Object)this.getTileForBlock(worldIn, pos));
        if (!worldIn.isClientSide && tileEntity != null) {
            BroadcastManager.removeBroadcastProducer(tileEntity.getUUID());
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileTransmitter tileEntity = (TileTransmitter)((Object)this.getTileForBlock(worldIn, pos));
        if (tileEntity != null) {
            ItemStack newStack = new ItemStack((ItemLike)stack.getItem(), 1);
            newStack.applyComponents(stack.getComponents());
            tileEntity.setSourceStack(newStack);
            if (!worldIn.isClientSide) {
                ServerTransmitterManager.createTransmitter(tileEntity);
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Arrays.asList(new ItemStack[0]);
    }

    @Override
    public BlockEntityType<TileTransmitter> getTileType() {
        return ModTiles.TRANSMITTER;
    }

    public int getSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public boolean isSignalSource(BlockState p_55730_) {
        return true;
    }
}

