/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.block.BlockConductor;
import io.github.tofodroid.mods.mimi.common.block.BlockEffectEmitter;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.BlockLedCube;
import io.github.tofodroid.mods.mimi.common.block.BlockListener;
import io.github.tofodroid.mods.mimi.common.block.BlockMechanicalMaestro;
import io.github.tofodroid.mods.mimi.common.block.BlockReceiver;
import io.github.tofodroid.mods.mimi.common.block.BlockRelay;
import io.github.tofodroid.mods.mimi.common.block.BlockTransmitter;
import io.github.tofodroid.mods.mimi.common.block.BlockTuningTable;
import io.github.tofodroid.mods.mimi.common.block.legacycompat.BlockBroadcaster;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentConfig;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static final Map<ResourceLocation, Block> BLOCKS = new HashMap<ResourceLocation, Block>();
    public static final BlockTransmitter TRANSMITTERBLOCK = ModBlocks.create("transmitterblock", new BlockTransmitter(BlockBehaviour.Properties.of()));
    public static final BlockMechanicalMaestro MECHANICALMAESTRO = ModBlocks.create("mechanicalmaestro", new BlockMechanicalMaestro(BlockBehaviour.Properties.of()));
    public static final BlockConductor CONDUCTOR = ModBlocks.create("conductor", new BlockConductor(BlockBehaviour.Properties.of()));
    public static final BlockEffectEmitter EFFECTEMITTER = ModBlocks.create("effectemitter", new BlockEffectEmitter(BlockBehaviour.Properties.of()));
    public static final BlockListener LISTENER = ModBlocks.create("listener", new BlockListener(BlockBehaviour.Properties.of()));
    public static final BlockReceiver RECEIVER = ModBlocks.create("receiver", new BlockReceiver(BlockBehaviour.Properties.of()));
    public static final BlockRelay RELAY = ModBlocks.create("relay", new BlockRelay(BlockBehaviour.Properties.of()));
    public static final BlockBroadcaster BROADCASTER = ModBlocks.create("broadcaster", new BlockBroadcaster());
    public static final BlockTuningTable TUNINGTABLE = ModBlocks.create("tuningtable", new BlockTuningTable());
    public static final BlockLedCube LEDCUBE_A = ModBlocks.create("ledcube_a", new BlockLedCube());
    public static final BlockLedCube LEDCUBE_B = ModBlocks.create("ledcube_b", new BlockLedCube());
    public static final BlockLedCube LEDCUBE_C = ModBlocks.create("ledcube_c", new BlockLedCube());
    public static final BlockLedCube LEDCUBE_D = ModBlocks.create("ledcube_d", new BlockLedCube());
    public static final BlockLedCube LEDCUBE_E = ModBlocks.create("ledcube_e", new BlockLedCube());
    public static final BlockLedCube LEDCUBE_F = ModBlocks.create("ledcube_f", new BlockLedCube());
    public static final BlockLedCube LEDCUBE_G = ModBlocks.create("ledcube_g", new BlockLedCube());
    public static final BlockLedCube LEDCUBE_H = ModBlocks.create("ledcube_h", new BlockLedCube());
    public static final List<BlockInstrument> INSTRUMENTS = ModBlocks.buildInstruments();
    public static final List<? extends AConfigurableTileBlock<?>> SETTINGS_SYNC_BLOCKS = List.of(LISTENER, RECEIVER, RELAY, EFFECTEMITTER);

    public static List<BlockInstrument> buildInstruments() {
        ArrayList<BlockInstrument> result = new ArrayList<BlockInstrument>();
        for (InstrumentSpec instrument : InstrumentConfig.getBlockInstruments()) {
            result.add(ModBlocks.create(instrument.registryName, new BlockInstrument(BlockBehaviour.Properties.of(), instrument)));
        }
        return result;
    }

    public static <T extends Block> T create(String id, T block) {
        BLOCKS.put(ResourceUtils.newModLocation(id), block);
        return block;
    }
}

