/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.container;

import io.github.tofodroid.mods.mimi.common.container.APlayerInventoryContainer;
import io.github.tofodroid.mods.mimi.common.container.ModContainers;
import io.github.tofodroid.mods.mimi.common.container.slot.SlotTuningResult;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrumentBlock;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrumentHandheld;
import io.github.tofodroid.mods.mimi.common.recipe.ModRecipes;
import io.github.tofodroid.mods.mimi.common.recipe.TuningTableRecipe;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class ContainerTuningTable
extends APlayerInventoryContainer {
    private static final int INSTRUMENT_SLOT_POS_X = 27;
    private static final int INSTRUMENT_SLOT_POS_Y = 38;
    private static final int MODIFIER_SLOT_POS_X = 76;
    private static final int MODIFiER_SLOT_POS_Y = 38;
    private static final int RESULT_SLOT_POS_X = 134;
    private static final int RESULT_SLOT_POS_Y = 38;
    private CraftingContainer craftingInventory = new TransientCraftingContainer((AbstractContainerMenu)this, 1, 2);
    private ResultContainer resultInventory = new ResultContainer();

    public ContainerTuningTable(int id, Inventory playerInventory) {
        super(ModContainers.TUNINGTABLE, id, playerInventory);
        this.addSlot(this.buildInstrumentSlot(27, 38));
        this.addSlot(this.buildModifierSlot(76, 38));
        this.addSlot(this.buildResultSlot(134, 38));
    }

    public ContainerTuningTable(int id, Inventory playerInventory, FriendlyByteBuf extraData) {
        super(ModContainers.TUNINGTABLE, id, playerInventory);
        this.addSlot(this.buildInstrumentSlot(27, 38));
        this.addSlot(this.buildModifierSlot(76, 38));
        this.addSlot(this.buildResultSlot(134, 38));
    }

    @Override
    protected Integer getPlayerInventoryX() {
        return 8;
    }

    @Override
    protected Integer getPlayerInventoryY() {
        return 93;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 38) {
                itemstack1.getItem().onCraftedBy(itemstack1, playerIn.level(), playerIn);
                if (!this.moveItemStackTo(itemstack1, 0, 35, false)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index >= 36 ? !this.moveItemStackTo(itemstack1, 0, 35, false) : !this.moveItemStackTo(itemstack1, 36, 36 + this.craftingInventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
            if (index == 38) {
                playerIn.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    public void slotsChanged(Container container) {
        if (container == this.craftingInventory && !this.playerInventory.player.level().isClientSide) {
            ServerPlayer serverplayer = (ServerPlayer)this.playerInventory.player;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = serverplayer.level().getServer().getRecipeManager().getRecipeFor(ModRecipes.TUNING_TYPE, (RecipeInput)this.craftingInventory.asCraftInput(), serverplayer.level());
            if (optional.isPresent() && this.resultInventory.setRecipeUsed(serverplayer.level(), serverplayer, (RecipeHolder)optional.get())) {
                itemstack = ((TuningTableRecipe)((RecipeHolder)optional.get()).value()).assemble(this.craftingInventory.asCraftInput(), null);
            }
            this.resultInventory.setItem(0, itemstack);
            this.setRemoteSlot(38, itemstack);
            serverplayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 38, itemstack));
        }
    }

    public void removed(Player p_39389_) {
        super.removed(p_39389_);
        this.clearContainer(p_39389_, (Container)this.craftingInventory);
    }

    protected Slot buildResultSlot(int xPos, int yPos) {
        return new SlotTuningResult(this.playerInventory.player, this.craftingInventory, (Container)this.resultInventory, 2, xPos, yPos);
    }

    protected Slot buildModifierSlot(int xPos, int yPos) {
        return new Slot((Container)this.craftingInventory, 1, xPos, yPos);
    }

    protected Slot buildInstrumentSlot(int xPos, int yPos) {
        return new Slot(this, (Container)this.craftingInventory, 0, xPos, yPos){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof ItemInstrumentHandheld || stack.getItem() instanceof ItemInstrumentBlock;
            }
        };
    }
}

