/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.entity;

import io.github.tofodroid.mods.mimi.common.entity.ModEntities;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableMidiNoteResponsiveTile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class EntityNoteResponsiveTile
extends Entity {
    public BlockPos source;

    public EntityNoteResponsiveTile(EntityType<? extends EntityNoteResponsiveTile> type, Level world) {
        super(ModEntities.NOTERESPONSIVETILE, world);
        this.noPhysics = true;
    }

    private EntityNoteResponsiveTile(Level world, BlockPos pos) {
        this(ModEntities.NOTERESPONSIVETILE, world);
        this.source = pos;
        this.setPos(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void tick() {
        super.tick();
        if (!(this.level().isClientSide || this.isRemoved() || this.source != null && this.level().getBlockEntity(this.source) != null && this.level().getBlockEntity(this.source) instanceof AConfigurableMidiNoteResponsiveTile)) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.source == null) {
            this.source = this.blockPosition();
        }
    }

    public AConfigurableMidiNoteResponsiveTile getTile() {
        BlockEntity tile = this.isAddedToWorld() && this.isAlive() ? this.level().getBlockEntity(this.source) : null;
        return tile != null && tile instanceof AConfigurableMidiNoteResponsiveTile ? (AConfigurableMidiNoteResponsiveTile)tile : null;
    }

    protected static EntityNoteResponsiveTile getAtPos(Level world, Double posX, Double posY, Double posZ) {
        List entities = world.getEntitiesOfClass(EntityNoteResponsiveTile.class, new AABB(posX - 0.05, posY - 0.05, posZ - 0.05, posX + 0.05, posY + 0.05, posZ + 0.05));
        return !entities.isEmpty() ? (EntityNoteResponsiveTile)((Object)entities.get(0)) : null;
    }

    public static Boolean entityExists(Level world, Double posX, Double posY, Double posZ) {
        return EntityNoteResponsiveTile.getAtPos(world, posX, posY, posZ) != null;
    }

    public static Boolean create(Level world, BlockPos pos) {
        EntityNoteResponsiveTile newMaestro;
        if (!world.isClientSide && !EntityNoteResponsiveTile.entityExists(world, (newMaestro = new EntityNoteResponsiveTile(world, pos)).getX(), newMaestro.getY(), newMaestro.getZ()).booleanValue()) {
            world.addFreshEntity((Entity)newMaestro);
            return true;
        }
        return false;
    }

    public static Boolean remove(Level world, BlockPos pos) {
        EntityNoteResponsiveTile entity;
        if (!world.isClientSide && (entity = EntityNoteResponsiveTile.getAtPos(world, Double.valueOf(pos.getX()), Double.valueOf(pos.getY()), Double.valueOf(pos.getZ()))) != null) {
            entity.remove(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.source = new BlockPos(tag.getInt("source_x"), tag.getInt("source_y"), tag.getInt("source_z"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.source != null) {
            tag.putInt("source_x", this.source.getX());
            tag.putInt("source_y", this.source.getY());
            tag.putInt("source_z", this.source.getY());
        }
    }
}

