/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.entity;

import io.github.tofodroid.mods.mimi.common.entity.ModEntities;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.server.events.broadcast.consumer.instrument.EntityInstrumentConsumerEventHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3d;

public class EntitySeat
extends Entity {
    protected BlockPos source;
    protected Player rider;

    public EntitySeat(EntityType<? extends EntitySeat> type, Level world) {
        super(type, world);
        this.noPhysics = true;
    }

    private EntitySeat(Level world, BlockPos source, Vector3d offset, Player rider) {
        this(ModEntities.SEAT, world);
        this.source = source;
        this.setPos((double)source.getX() + offset.x, (double)source.getY() + offset.y, (double)source.getZ() + offset.z);
        if (rider != null) {
            this.rider = rider;
            rider.startRiding((Entity)this);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public Player getRider() {
        return this.rider;
    }

    public void remove(Entity.RemovalReason p_146834_) {
        if (!this.level().isClientSide) {
            this.ejectPassengers();
            if (this.rider != null) {
                EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers((LivingEntity)this.rider);
            }
            this.level().updateNeighbourForOutputSignal(this.source, this.level().getBlockState(this.source).getBlock());
        }
        super.remove(p_146834_);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            BlockEntity blockEntity = this.level().getBlockEntity(this.source);
            if (this.source == null || this.getPassengers().isEmpty() || blockEntity == null || !(blockEntity instanceof TileInstrument) || this.getPassengers().stream().allMatch(e -> !e.isAddedToWorld() || !e.isAlive() || !(e instanceof Player))) {
                this.discard();
            }
        }
        if (this.source == null) {
            this.source = this.blockPosition();
        }
    }

    public BlockPos getSource() {
        return this.source;
    }

    public static Boolean seatExists(Level world, BlockPos pos, Vector3d sitOffsetPos) {
        EntitySeat newSeat = new EntitySeat(world, pos, sitOffsetPos, null);
        return EntitySeat.seatExists(world, newSeat.getX(), newSeat.getY(), newSeat.getZ());
    }

    public static EntitySeat getExisting(Level world, BlockPos pos, Vector3d sitOffsetPos) {
        EntitySeat newSeat = new EntitySeat(world, pos, sitOffsetPos, null);
        return EntitySeat.getExisting(world, newSeat.getX(), newSeat.getY(), newSeat.getZ());
    }

    private static Boolean seatExists(Level world, Double posX, Double posY, Double posZ) {
        List seats = world.getEntitiesOfClass(EntitySeat.class, new AABB(posX - 0.05, posY - 0.05, posZ - 0.05, posX + 0.05, posY + 0.05, posZ + 0.05));
        return !seats.isEmpty();
    }

    private static EntitySeat getExisting(Level world, Double posX, Double posY, Double posZ) {
        List seats = world.getEntitiesOfClass(EntitySeat.class, new AABB(posX - 0.05, posY - 0.05, posZ - 0.05, posX + 0.05, posY + 0.05, posZ + 0.05));
        if (!seats.isEmpty()) {
            return (EntitySeat)((Object)seats.get(0));
        }
        return null;
    }

    public static EntitySeat create(Level world, BlockPos pos, Vector3d sitOffsetPos, Player player) {
        EntitySeat newSeat;
        if (!world.isClientSide && !EntitySeat.seatExists(world, (newSeat = new EntitySeat(world, pos, sitOffsetPos, player)).getX(), newSeat.getY(), newSeat.getZ()).booleanValue()) {
            world.addFreshEntity((Entity)newSeat);
            player.startRiding((Entity)newSeat, false);
            EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers((LivingEntity)player);
            return newSeat;
        }
        return null;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.source = new BlockPos(tag.getInt("source_x"), tag.getInt("source_y"), tag.getInt("source_z"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.source != null) {
            tag.putInt("source_x", this.source.getX());
            tag.putInt("source_y", this.source.getY());
            tag.putInt("source_z", this.source.getY());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }
}

