/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import vazkii.patchouli.api.PatchouliAPI;

public class ItemGuide
extends Item {
    public static final String REGISTRY_NAME = "guide";
    public static final ClickEvent onClickP = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/patchouli");
    public static final ClickEvent onClickM = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/tofodroid/mimi-mod/wiki");

    public ItemGuide(Item.Properties props) {
        super(props.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.literal((String)"3rd Edition").withStyle(ChatFormatting.GRAY));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (ModList.get().isLoaded("patchouli")) {
                PatchouliAPI.get().openBookGUI(serverPlayer, ResourceUtils.newModLocation(REGISTRY_NAME));
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
            }
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"The ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"Patchouli Mod").withStyle(style -> style.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(onClickP))).append((Component)Component.literal((String)" must be installed to read this book.").withStyle(ChatFormatting.DARK_RED)));
            serverPlayer.sendSystemMessage((Component)Component.literal((String)""));
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"Visit the ").append((Component)Component.literal((String)"MIMI Wiki").withStyle(style -> style.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(onClickM))).append((Component)Component.literal((String)" for online documentation!")));
            serverPlayer.sendSystemMessage((Component)Component.literal((String)""));
        }
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)playerIn.getItemInHand(handIn));
    }
}

