/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.block.BlockEffectEmitter;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemSettingsSync
extends Item {
    public static final String REGISTRY_NAME = "settingssync";
    public static final Integer INSTRUMENT_SETTING_TYPE = -1;
    public static final Integer NONE_SETTING_TYPE = -2;

    public ItemSettingsSync(Item.Properties props) {
        super(props.stacksTo(64));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Integer settingType = this.getSettingType(stack);
        if (settingType < 0) {
            tooltip.add((Component)Component.literal((String)"Crouch + Right-Click Block to Copy Settings").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.literal((String)"Right-Click Block of Same Type to Paste").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            tooltip.add((Component)Component.literal((String)""));
        }
        if (settingType == INSTRUMENT_SETTING_TYPE) {
            tooltip.add((Component)Component.literal((String)"Instrument").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD, ChatFormatting.ITALIC}));
            IInstrumentItem.appendInstrumentTooltip(stack, tooltip);
        } else if (settingType >= 0) {
            AConfigurableTileBlock<?> block = ModBlocks.SETTINGS_SYNC_BLOCKS.get(settingType);
            tooltip.add((Component)block.getName().withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD, ChatFormatting.ITALIC}));
            block.appendHoverText(stack, context, tooltip, flagIn);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide && !playerIn.isCrouching()) {
            Integer settingType = this.getSettingType(heldItem);
            if (settingType == INSTRUMENT_SETTING_TYPE) {
                ClientGuiWrapper.openInstrumentGui(worldIn, playerIn, null, handIn, heldItem);
                return InteractionResultHolder.success((Object)heldItem);
            }
            if (settingType >= 0) {
                ModBlocks.SETTINGS_SYNC_BLOCKS.get(settingType).openGuiWrapper().accept(worldIn, playerIn, null, handIn, heldItem);
                return InteractionResultHolder.success((Object)heldItem);
            }
        }
        return InteractionResultHolder.pass((Object)heldItem);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack heldItem = context.getItemInHand();
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() instanceof AConfigurableTileBlock) {
            AConfigurableTileBlock block = (AConfigurableTileBlock)state.getBlock();
            BiFunction<ItemStack, ItemStack, ItemStack> copyFunction = ((Object)((Object)block)).equals((Object)ModBlocks.EFFECTEMITTER) ? BlockEffectEmitter::copyEffectEmitterSettings : MidiNbtDataUtils::copyMidiSettings;
            Integer blockSettingType = this.toSettingType(block);
            Integer stackSettingType = this.getSettingType(heldItem);
            if (blockSettingType >= -1) {
                if (!context.getLevel().isClientSide) {
                    if (context.isSecondaryUseActive()) {
                        ItemStack newStack = copyFunction.apply(block.getSourceStack(context.getLevel(), context.getClickedPos()), heldItem);
                        TagUtils.setOrRemoveInt(newStack, "setting_type", blockSettingType);
                        context.getPlayer().setItemInHand(context.getHand(), newStack);
                        MutableComponent message = Component.literal((String)"Copied ").append((Component)state.getBlock().getName()).append((Component)Component.literal((String)" Settings to Synchronizer"));
                        context.getPlayer().displayClientMessage((Component)message, true);
                    } else if (stackSettingType == blockSettingType) {
                        block.setSourceStack(context.getLevel(), context.getClickedPos(), copyFunction.apply(heldItem, block.getSourceStack(context.getLevel(), context.getClickedPos())));
                        MutableComponent message = Component.literal((String)"Applied Synchronizer Settings to ").append((Component)state.getBlock().getName());
                        context.getPlayer().displayClientMessage((Component)message, true);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public Integer toSettingType(AConfigurableTileBlock<?> block) {
        if (block instanceof BlockInstrument) {
            return INSTRUMENT_SETTING_TYPE;
        }
        return ModBlocks.SETTINGS_SYNC_BLOCKS.indexOf(block);
    }

    public Integer getSettingType(ItemStack stack) {
        Integer raw = TagUtils.getIntOrDefault((DataComponentHolder)stack, "setting_type", NONE_SETTING_TYPE);
        return raw >= NONE_SETTING_TYPE && raw < ModBlocks.SETTINGS_SYNC_BLOCKS.size() ? raw : NONE_SETTING_TYPE;
    }
}

