/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableTile;
import io.github.tofodroid.mods.mimi.common.tile.TileRelay;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ItemSourceLinker
extends Item {
    public static final String REGISTRY_NAME = "sourcelinker";

    public ItemSourceLinker(Item.Properties props) {
        super(props.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (MidiNbtDataUtils.getMidiSource(stack) == null) {
            tooltip.add((Component)Component.literal((String)"Crouch + Right-Click to Link to a Transmitter").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.literal((String)"Right-Click Block to Link it to Saved Transmitter").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        tooltip.add((Component)Component.literal((String)""));
        MidiNbtDataUtils.appendMidiSourceTooltip(stack, tooltip);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity target, InteractionHand handIn) {
        if (target instanceof Player && user.isCrouching()) {
            if (!user.level().isClientSide) {
                MidiNbtDataUtils.setMidiSource(stack, target.getUUID(), target.getName().getString());
                user.setItemInHand(handIn, stack);
                MutableComponent message = Component.literal((String)"Linked ").append(stack.getHoverName()).append((Component)Component.literal((String)" to ")).append(target.getName());
                user.displayClientMessage((Component)message, true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.getItemInHand(handIn);
        if (playerIn.isCrouching()) {
            if (!worldIn.isClientSide) {
                MidiNbtDataUtils.setMidiSource(heldItem, playerIn.getUUID(), playerIn.getName().getString());
                playerIn.setItemInHand(handIn, heldItem);
                MutableComponent message = Component.literal((String)"Linked ").append(heldItem.getHoverName()).append((Component)Component.literal((String)" to ")).append(playerIn.getName());
                playerIn.displayClientMessage((Component)message, true);
            }
            return InteractionResultHolder.success((Object)heldItem);
        }
        return InteractionResultHolder.pass((Object)heldItem);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        Block block = level.getBlockState(pos).getBlock();
        return block.equals((Object)ModBlocks.TRANSMITTERBLOCK) || block.equals((Object)ModBlocks.RELAY);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack heldItem = context.getItemInHand();
        UUID savedSource = MidiNbtDataUtils.getMidiSource(heldItem);
        if (!context.isSecondaryUseActive() && savedSource != null) {
            String savedSourceName = MidiNbtDataUtils.getMidiSourceName(heldItem, false);
            BlockState state = context.getLevel().getBlockState(context.getClickedPos());
            if (state.getBlock() instanceof BlockInstrument || state.getBlock().equals((Object)ModBlocks.RECEIVER) || state.getBlock().equals((Object)ModBlocks.RELAY)) {
                AConfigurableTile tile;
                if (!(context.getLevel().isClientSide || (tile = (AConfigurableTile)((Object)((AConfigurableTileBlock)state.getBlock()).getTileForBlock(context.getLevel(), context.getClickedPos()))) == null || tile instanceof TileRelay && ((TileRelay)tile).getUUID().equals(savedSource))) {
                    ItemStack sourceStack = tile.getSourceStack();
                    MidiNbtDataUtils.setMidiSource(sourceStack, savedSource, savedSourceName);
                    tile.setSourceStack(sourceStack);
                    MutableComponent message = Component.literal((String)"Linked ").append((Component)state.getBlock().getName()).append((Component)Component.literal((String)" to configured ")).append(MidiNbtDataUtils.getMidiSourceType(heldItem));
                    context.getPlayer().displayClientMessage((Component)message, true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

