/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentConfig;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.common.item.ItemGuide;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrumentBlock;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrumentHandheld;
import io.github.tofodroid.mods.mimi.common.item.ItemMidiSourceLinkableBlock;
import io.github.tofodroid.mods.mimi.common.item.ItemSettingsSync;
import io.github.tofodroid.mods.mimi.common.item.ItemSourceLinker;
import io.github.tofodroid.mods.mimi.common.item.ItemTransmitter;
import io.github.tofodroid.mods.mimi.common.item.legacycompat.ItemFileCaster;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public final class ModItems {
    public static Map<ResourceLocation, Item> ITEMS = new HashMap<ResourceLocation, Item>();
    public static Map<ResourceLocation, CreativeModeTab> CREATIVE_TABS = new HashMap<ResourceLocation, CreativeModeTab>();
    public static List<ItemInstrumentHandheld> INSTRUMENT_ITEMS = ModItems.buildHandheldInstruments();
    public static List<ItemInstrumentBlock> BLOCK_INSTRUMENT_ITEMS = ModItems.buildBlockInstruments();
    public static ItemFileCaster FILECASTER = ModItems.create("filecaster", new ItemFileCaster(new Item.Properties()));
    public static BlockItem BROADCASTER = ModItems.create("broadcaster", new BlockItem((Block)ModBlocks.BROADCASTER, new Item.Properties().stacksTo(64)));
    public static ItemSettingsSync SETTINGSSYNC = ModItems.create("settingssync", new ItemSettingsSync(new Item.Properties()));
    public static ItemSourceLinker SOURCELINKER = ModItems.create("sourcelinker", new ItemSourceLinker(new Item.Properties()));
    public static ItemTransmitter TRANSMITTER = ModItems.create("transmitter", new ItemTransmitter(new Item.Properties()));
    public static ItemGuide GUIDE = ModItems.create("guide", new ItemGuide(new Item.Properties()));
    public static BlockItem TRANSMITTERBLOCK = ModItems.create("transmitterblock", new BlockItem((Block)ModBlocks.TRANSMITTERBLOCK, new Item.Properties().stacksTo(64)));
    public static BlockItem LISTENER = ModItems.create("listener", new BlockItem((Block)ModBlocks.LISTENER, new Item.Properties().stacksTo(64)));
    public static BlockItem CONDUCTOR = ModItems.create("conductor", new BlockItem((Block)ModBlocks.CONDUCTOR, new Item.Properties().stacksTo(64)));
    public static BlockItem EFFECTEMITTER = ModItems.create("effectemitter", new BlockItem((Block)ModBlocks.EFFECTEMITTER, new Item.Properties().stacksTo(64)));
    public static BlockItem MECHANICALMAESTRO = ModItems.create("mechanicalmaestro", new BlockItem((Block)ModBlocks.MECHANICALMAESTRO, new Item.Properties().stacksTo(64)));
    public static BlockItem RECEIVER = ModItems.create("receiver", new ItemMidiSourceLinkableBlock((Block)ModBlocks.RECEIVER, new Item.Properties().stacksTo(64)));
    public static BlockItem RELAY = ModItems.create("relay", new ItemMidiSourceLinkableBlock((Block)ModBlocks.RELAY, new Item.Properties().stacksTo(64)));
    public static BlockItem LEDCUBE_A = ModItems.create("ledcube_a", new BlockItem((Block)ModBlocks.LEDCUBE_A, new Item.Properties().stacksTo(64)));
    public static BlockItem LEDCUBE_B = ModItems.create("ledcube_b", new BlockItem((Block)ModBlocks.LEDCUBE_B, new Item.Properties().stacksTo(64)));
    public static BlockItem LEDCUBE_C = ModItems.create("ledcube_c", new BlockItem((Block)ModBlocks.LEDCUBE_C, new Item.Properties().stacksTo(64)));
    public static BlockItem LEDCUBE_D = ModItems.create("ledcube_d", new BlockItem((Block)ModBlocks.LEDCUBE_D, new Item.Properties().stacksTo(64)));
    public static BlockItem LEDCUBE_E = ModItems.create("ledcube_e", new BlockItem((Block)ModBlocks.LEDCUBE_E, new Item.Properties().stacksTo(64)));
    public static BlockItem LEDCUBE_F = ModItems.create("ledcube_f", new BlockItem((Block)ModBlocks.LEDCUBE_F, new Item.Properties().stacksTo(64)));
    public static BlockItem LEDCUBE_G = ModItems.create("ledcube_g", new BlockItem((Block)ModBlocks.LEDCUBE_G, new Item.Properties().stacksTo(64)));
    public static BlockItem LEDCUBE_H = ModItems.create("ledcube_h", new BlockItem((Block)ModBlocks.LEDCUBE_H, new Item.Properties().stacksTo(64)));
    public static BlockItem TUNINGTABLE = ModItems.create("tuningtable", new BlockItem((Block)ModBlocks.TUNINGTABLE, new Item.Properties().stacksTo(64)));
    public static CreativeModeTab CREATIVE_TAB = ModItems.create("group", CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.mimi.group")).icon(() -> new ItemStack((ItemLike)ModBlocks.INSTRUMENTS.get(0))).displayItems((parameters, output) -> {
        output.accept((ItemLike)GUIDE);
        output.acceptAll(ModItems.getStacksForItems(INSTRUMENT_ITEMS));
        output.acceptAll(ModItems.getStacksForItems(BLOCK_INSTRUMENT_ITEMS));
        output.acceptAll(ModItems.getStacksForItems(Arrays.asList(new Item[]{SOURCELINKER, SETTINGSSYNC, TRANSMITTER, LISTENER, RECEIVER, MECHANICALMAESTRO, EFFECTEMITTER, RELAY, TRANSMITTERBLOCK, TUNINGTABLE, LEDCUBE_A, LEDCUBE_B, LEDCUBE_C, LEDCUBE_D, LEDCUBE_E, LEDCUBE_F, LEDCUBE_G, LEDCUBE_H})));
    }));

    public static List<ItemStack> getStacksForItems(List<? extends Item> items) {
        return items.stream().map(i -> new ItemStack((ItemLike)i)).collect(Collectors.toList());
    }

    public static List<ItemInstrumentHandheld> buildHandheldInstruments() {
        ArrayList<ItemInstrumentHandheld> list = new ArrayList<ItemInstrumentHandheld>();
        for (InstrumentSpec instrument : InstrumentConfig.getItemInstruments()) {
            list.add(ModItems.create(instrument.registryName, new ItemInstrumentHandheld(new Item.Properties(), instrument)));
        }
        return list;
    }

    public static List<ItemInstrumentBlock> buildBlockInstruments() {
        ArrayList<ItemInstrumentBlock> list = new ArrayList<ItemInstrumentBlock>();
        for (InstrumentSpec instrument : InstrumentConfig.getBlockInstruments()) {
            Block block = ModBlocks.BLOCKS.get(ResourceUtils.newModLocation(instrument.registryName));
            if (block instanceof BlockInstrument) {
                list.add(ModItems.create(instrument.registryName, new ItemInstrumentBlock((BlockInstrument)block, new Item.Properties().stacksTo(1), instrument.registryName)));
                continue;
            }
            MIMIMod.LOGGER.error("Failed to create ItemInstrumentBlock for Instrument: " + instrument.registryName + " - Corresponding Registry Block is not a BlockInstrument!");
        }
        return list;
    }

    public static CreativeModeTab create(String id, CreativeModeTab.Builder builder) {
        CreativeModeTab tab = builder.build();
        CREATIVE_TABS.put(ResourceUtils.newModLocation(id), tab);
        return tab;
    }

    public static <T extends Item> T create(String id, T item) {
        ITEMS.put(ResourceUtils.newModLocation(id), item);
        return item;
    }
}

