/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.midi;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import io.github.tofodroid.mods.mimi.common.midi.BasicMidiInfo;
import io.github.tofodroid.mods.mimi.common.midi.LocalMidiInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;

public class FilesystemMidiFileProvider {
    public static final String MIMI_CONFIG_DIR = "mimi";
    public static final String DEFAULT_CLIENT_MIDI_DIR = "midi_files";
    public static final String SERVER_MIDI_DIR = "server_midi_files";
    public static final Integer MAX_SONG_COUNT = 50;
    public static final Integer MAX_FILESIZE_BYTES = 1000;
    public static final FilenameFilter MIDI_FILTER = (dir, name) -> name.endsWith(".mid") || name.endsWith(".midi");
    protected final Boolean isServer;
    protected Map<UUID, LocalMidiInfo> songMap;
    protected List<UUID> orderedSongList;
    protected Instant lastLoad = Instant.MIN;
    protected File selectedFolder = null;
    protected String lastFolderHash = null;

    public FilesystemMidiFileProvider(Boolean isServer) {
        this.isServer = isServer;
        this.songMap = new HashMap<UUID, LocalMidiInfo>();
        this.orderedSongList = new ArrayList<UUID>();
        this.init();
    }

    protected void clear() {
        this.songMap = new HashMap<UUID, LocalMidiInfo>();
        this.orderedSongList = new ArrayList<UUID>();
    }

    public List<UUID> getSortedSongIds() {
        return this.orderedSongList;
    }

    public void setDirectory(String newDirectory) {
        this.initFromDirectory(new File(newDirectory));
    }

    public List<BasicMidiInfo> getSortedSongInfos() {
        ArrayList<BasicMidiInfo> result = new ArrayList<BasicMidiInfo>();
        for (UUID id : this.getSortedSongIds()) {
            result.add(this.getInfoById(id).getBasicMidiInfo());
        }
        return result;
    }

    public LocalMidiInfo getInfoById(UUID id) {
        return this.songMap.get(id);
    }

    public Integer getSongCount() {
        return this.songMap.size();
    }

    public Boolean isEmpty() {
        return this.songMap.isEmpty();
    }

    public HashMap<UUID, LocalMidiInfo> buildSongMap(List<LocalMidiInfo> allFiles) {
        HashMap<UUID, LocalMidiInfo> resultMap = new HashMap<UUID, LocalMidiInfo>();
        allFiles.forEach(midiFile -> resultMap.put(midiFile.fileId, (LocalMidiInfo)midiFile));
        return resultMap;
    }

    public List<UUID> buildOrderList(List<LocalMidiInfo> allFiles) {
        ArrayList<LocalMidiInfo> copy = new ArrayList<LocalMidiInfo>(allFiles);
        copy.sort((midiA, midiB) -> midiA.file.getName().toLowerCase().trim().compareTo(midiB.file.getName().toLowerCase().trim()));
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (LocalMidiInfo info : copy) {
            UUID songId = info.fileId;
            if (result.contains(songId)) continue;
            result.add(songId);
        }
        return result;
    }

    public void loadSongs() {
        if (this.folderExists().booleanValue()) {
            File[] midiFiles = this.loadFiles();
            if (midiFiles != null) {
                this.clear();
                List<LocalMidiInfo> allFiles = this.loadFilesystemSongs(midiFiles);
                this.songMap = this.buildSongMap(allFiles);
                this.orderedSongList = this.buildOrderList(allFiles);
            }
        } else {
            this.clear();
            this.lastFolderHash = null;
            MIMIMod.LOGGER.error("MIMI MIDI Folder no longer exists: " + this.selectedFolder.getAbsolutePath());
        }
    }

    public Boolean folderExists() {
        return this.selectedFolder.exists() && this.selectedFolder.isDirectory();
    }

    public File[] loadFiles() {
        File[] files = this.selectedFolder.listFiles(MIDI_FILTER);
        Arrays.sort(files, (a, b) -> a.getName().compareTo(b.getName()));
        if (files.length > MAX_SONG_COUNT) {
            MIMIMod.LOGGER.warn("More than " + MAX_SONG_COUNT + " MIDI files found in current folder. MIMI can currently only load up to " + MAX_SONG_COUNT + ".");
            files = Arrays.copyOfRange(files, 0, (int)MAX_SONG_COUNT);
        }
        return files;
    }

    public String getCurrentFolderPath() {
        return this.selectedFolder.getAbsolutePath();
    }

    protected void initFromDirectory(File directory) {
        this.clear();
        if (directory != null && directory.exists() && directory.isDirectory()) {
            this.selectedFolder = directory;
            this.loadSongs();
        } else {
            MIMIMod.LOGGER.error("Failed to open MIDI directory: " + directory.getAbsolutePath());
        }
    }

    public FilesystemMidiFileProvider init() {
        try {
            File mimiFolder = new File(ConfigProxy.getConfigPath().toString(), MIMI_CONFIG_DIR);
            if (!(mimiFolder.exists() || mimiFolder.mkdirs() || mimiFolder.isDirectory())) {
                throw new IOException("Could not create MIMI config directory!");
            }
            File defaultMidiFolder = new File(mimiFolder.getAbsolutePath(), this.isServer != false ? SERVER_MIDI_DIR : DEFAULT_CLIENT_MIDI_DIR);
            if (!(defaultMidiFolder.exists() || defaultMidiFolder.mkdirs() || defaultMidiFolder.isDirectory())) {
                throw new IOException("Could not create MIMI MIDI directory!");
            }
            if (this.isServer.booleanValue() || ConfigProxy.getTransmitterMidiPath() == null || ConfigProxy.getTransmitterMidiPath().isBlank()) {
                this.initFromDirectory(defaultMidiFolder);
            } else {
                File userMidiFolder = new File(ConfigProxy.getTransmitterMidiPath());
                this.initFromDirectory(userMidiFolder);
            }
        }
        catch (Exception e) {
            this.clear();
            MIMIMod.LOGGER.error("Failed to configure MIDI file manager.", (Throwable)e);
        }
        return this;
    }

    protected List<LocalMidiInfo> loadFilesystemSongs(File[] midiFiles) {
        ArrayList<LocalMidiInfo> allFiles = new ArrayList<LocalMidiInfo>();
        try {
            for (File file : midiFiles) {
                LocalMidiInfo info = LocalMidiInfo.fromFile(file, this.isServer);
                if (info == null) continue;
                allFiles.add(info);
            }
        }
        catch (Exception e) {
            MIMIMod.LOGGER.error("Failed to load MIDI files from directory '" + this.selectedFolder.getAbsolutePath() + "' - ", (Object)e.getMessage());
        }
        return allFiles;
    }

    public File saveSequenceToCurrentFolder(String fileName, Sequence sequence, Boolean overwrite) throws IOException {
        if (this.selectedFolder != null) {
            File file;
            File targetFile = new File(this.selectedFolder, fileName.replace(" ", "_").replaceAll("[^A-Za-z0-9_-]", "_") + ".mid");
            if (targetFile.exists() && !overwrite.booleanValue()) {
                throw new IOException("Target file '" + targetFile.getAbsolutePath() + "' already exists and overwrite is disabled!");
            }
            Files.deleteIfExists(targetFile.toPath());
            FileOutputStream fout = new FileOutputStream(targetFile);
            try {
                MidiSystem.write(sequence, MidiSystem.getMidiFileTypes(sequence)[0], fout);
                fout.close();
                file = targetFile;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fout.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            fout.close();
            return file;
        }
        return null;
    }
}

