/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.network.ConfigurableMidiTileSyncPacket;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableMidiTile;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ConfigurableMidiTileSyncPacketHandler {
    public static void handlePacketClient(ConfigurableMidiTileSyncPacket message) {
        MIMIMod.LOGGER.warn("Client received unexpected ConfigurableMidiTileSyncPacket!");
    }

    public static void handlePacketServer(ConfigurableMidiTileSyncPacket message, ServerPlayer sender) {
        ItemStack handStack;
        if (message.tilePos != null) {
            AConfigurableMidiTile tile = (AConfigurableMidiTile)sender.level().getBlockEntity(message.tilePos);
            if (tile != null) {
                tile.setSourceStack(ConfigurableMidiTileSyncPacketHandler.applyToStack(message, tile.getSourceStack()));
            }
        } else if (message.handIn != null && (handStack = sender.getItemInHand(message.handIn)).getItem().equals((Object)ModItems.SETTINGSSYNC)) {
            sender.setItemInHand(message.handIn, ConfigurableMidiTileSyncPacketHandler.applyToStack(message, handStack));
        }
    }

    private static ItemStack applyToStack(ConfigurableMidiTileSyncPacket message, ItemStack midiStack) {
        MidiNbtDataUtils.setMidiSource(midiStack, message.midiSource, message.midiSourceName);
        MidiNbtDataUtils.setEnabledChannelsInt(midiStack, message.enabledChannelsInt);
        MidiNbtDataUtils.setFilterInstrument(midiStack, message.instrumentId);
        MidiNbtDataUtils.setFilterNote(midiStack, message.filterNote);
        MidiNbtDataUtils.setFilterOct(midiStack, message.filterOct);
        MidiNbtDataUtils.setInvertNoteOct(midiStack, message.invertNoteOct);
        MidiNbtDataUtils.setInvertSignal(midiStack, message.invertSignal);
        MidiNbtDataUtils.setTriggerNoteStart(midiStack, message.triggerNoteStart);
        MidiNbtDataUtils.setHoldTicks(midiStack, message.holdTicks);
        MidiNbtDataUtils.setBroadcastRange(midiStack, message.broadcastRange);
        MidiNbtDataUtils.setChannelMap(midiStack, message.channelMap);
        return midiStack;
    }
}

