/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.util.NetworkUtils;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import io.netty.handler.codec.DecoderException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class EffectEmitterUpdatePacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceUtils.newModLocation(EffectEmitterUpdatePacket.class.getSimpleName().toLowerCase());
    public static final CustomPacketPayload.Type<EffectEmitterUpdatePacket> TYPE = new CustomPacketPayload.Type(ID);
    public final BlockPos tilePos;
    public final InteractionHand handIn;
    public final String sound;
    public final String particle;
    public final Byte volume;
    public final Byte pitch;
    public final Byte side;
    public final Byte spread;
    public final Byte count;
    public final Byte speed_x;
    public final Byte speed_y;
    public final Byte speed_z;
    public final Integer sound_loop;
    public final Integer particle_loop;
    public final Boolean invertSignal;

    public EffectEmitterUpdatePacket(ItemStack stack, BlockPos tilePos, InteractionHand handIn) {
        this(tilePos, handIn, TagUtils.getStringOrDefault((DataComponentHolder)stack, "sound", ""), TagUtils.getStringOrDefault((DataComponentHolder)stack, "particle", ""), TagUtils.getByteOrDefault(stack, "volume", 5), TagUtils.getByteOrDefault(stack, "pitch", 0), TagUtils.getByteOrDefault(stack, "side", 0), TagUtils.getByteOrDefault(stack, "spread", 0), TagUtils.getByteOrDefault(stack, "count", 1), TagUtils.getByteOrDefault(stack, "speed_x", 0), TagUtils.getByteOrDefault(stack, "speed_y", 0), TagUtils.getByteOrDefault(stack, "speed_z", 0), TagUtils.getIntOrDefault((DataComponentHolder)stack, "sound_loop", 0), TagUtils.getIntOrDefault((DataComponentHolder)stack, "particle_loop", 0), TagUtils.getBooleanOrDefault((DataComponentHolder)stack, "invert_signal", false));
    }

    public EffectEmitterUpdatePacket(BlockPos tilePos, InteractionHand handIn, String sound, String particle, Byte volume, Byte pitch, Byte side, Byte spread, Byte count, Byte speed_x, Byte speed_y, Byte speed_z, Integer sound_loop, Integer particle_loop, Boolean invertSignal) {
        this.tilePos = tilePos;
        this.handIn = handIn;
        this.sound = sound != null ? sound : "";
        this.particle = particle != null ? particle : "";
        this.volume = volume != null ? volume : (byte)0;
        this.pitch = pitch != null ? pitch : (byte)0;
        this.side = side != null ? side : (byte)0;
        this.spread = spread != null ? spread : (byte)0;
        this.count = count != null ? count : (byte)0;
        this.speed_x = speed_x != null ? speed_x : (byte)0;
        this.speed_y = speed_y != null ? speed_y : (byte)0;
        this.speed_z = speed_z != null ? speed_z : (byte)0;
        this.sound_loop = sound_loop != null ? sound_loop : 0;
        this.particle_loop = particle_loop != null ? particle_loop : 0;
        this.invertSignal = invertSignal != null ? invertSignal : false;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static EffectEmitterUpdatePacket decodePacket(FriendlyByteBuf buf) {
        try {
            Boolean isHand = buf.readBoolean();
            InteractionHand handIn = null;
            BlockPos tilePos = null;
            if (isHand.booleanValue()) {
                handIn = NetworkUtils.decodeHand(buf.readByte());
            } else {
                tilePos = buf.readBlockPos();
            }
            String sound = buf.readUtf(512);
            String particle = buf.readUtf(512);
            Byte volume = buf.readByte();
            Byte pitch = buf.readByte();
            Byte side = buf.readByte();
            Byte spread = buf.readByte();
            Byte count = buf.readByte();
            Byte speed_x = buf.readByte();
            Byte speed_y = buf.readByte();
            Byte speed_z = buf.readByte();
            Integer sound_loop = buf.readInt();
            Integer particle_loop = buf.readInt();
            Boolean invertSignal = buf.readBoolean();
            return new EffectEmitterUpdatePacket(tilePos, handIn, sound, particle, volume, pitch, side, spread, count, speed_x, speed_y, speed_z, sound_loop, particle_loop, invertSignal);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("EffectEmitterUpdatePacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
        catch (DecoderException e) {
            MIMIMod.LOGGER.error("EffectEmitterUpdatePacket contained invalid bytes. Exception: " + String.valueOf((Object)e));
            return null;
        }
    }

    public static void encodePacket(EffectEmitterUpdatePacket pkt, FriendlyByteBuf buf) {
        if (pkt.handIn != null) {
            buf.writeBoolean(true);
            buf.writeByte((int)NetworkUtils.encodeHand(pkt.handIn).byteValue());
        } else {
            buf.writeBoolean(false);
            buf.writeBlockPos(pkt.tilePos);
        }
        buf.writeUtf(pkt.sound, 512);
        buf.writeUtf(pkt.particle, 512);
        buf.writeByte((int)pkt.volume.byteValue());
        buf.writeByte((int)pkt.pitch.byteValue());
        buf.writeByte((int)pkt.side.byteValue());
        buf.writeByte((int)pkt.spread.byteValue());
        buf.writeByte((int)pkt.count.byteValue());
        buf.writeByte((int)pkt.speed_x.byteValue());
        buf.writeByte((int)pkt.speed_y.byteValue());
        buf.writeByte((int)pkt.speed_z.byteValue());
        buf.writeInt(pkt.sound_loop.intValue());
        buf.writeInt(pkt.particle_loop.intValue());
        buf.writeBoolean(pkt.invertSignal.booleanValue());
    }
}

