/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.network.EffectEmitterUpdatePacket;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileEffectEmitter;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class EffectEmitterUpdatePacketHandler {
    public static void handlePacketClient(EffectEmitterUpdatePacket message) {
        MIMIMod.LOGGER.warn("Client received unexpected EffectEmitterUpdatePacket!");
    }

    public static void handlePacketServer(EffectEmitterUpdatePacket message, ServerPlayer sender) {
        ItemStack handStack;
        if (message.tilePos != null) {
            Optional tile = sender.level().getBlockEntity(message.tilePos, ModTiles.EFFECTEMITTER);
            if (tile.isPresent()) {
                ItemStack sourceStack = ((TileEffectEmitter)((Object)tile.get())).getSourceStack().copy();
                ((TileEffectEmitter)((Object)tile.get())).setSourceStack(EffectEmitterUpdatePacketHandler.applyToStack(message, sourceStack));
            }
        } else if (message.handIn != null && (handStack = sender.getItemInHand(message.handIn)).getItem().equals((Object)ModItems.SETTINGSSYNC)) {
            sender.setItemInHand(message.handIn, EffectEmitterUpdatePacketHandler.applyToStack(message, handStack));
        }
    }

    private static ItemStack applyToStack(EffectEmitterUpdatePacket message, ItemStack sourceStack) {
        TagUtils.setOrRemoveBoolean(sourceStack, "invert_signal", message.invertSignal);
        TagUtils.setOrRemoveString(sourceStack, "sound", message.sound);
        TagUtils.setOrRemoveString(sourceStack, "particle", message.particle);
        TagUtils.setOrRemoveByte(sourceStack, "volume", message.volume);
        TagUtils.setOrRemoveByte(sourceStack, "pitch", message.pitch);
        TagUtils.setOrRemoveByte(sourceStack, "side", message.side);
        TagUtils.setOrRemoveByte(sourceStack, "spread", message.spread);
        TagUtils.setOrRemoveByte(sourceStack, "count", message.count);
        TagUtils.setOrRemoveByte(sourceStack, "speed_x", message.speed_x);
        TagUtils.setOrRemoveByte(sourceStack, "speed_y", message.speed_y);
        TagUtils.setOrRemoveByte(sourceStack, "speed_z", message.speed_z);
        TagUtils.setOrRemoveInt(sourceStack, "sound_loop", message.sound_loop);
        TagUtils.setOrRemoveInt(sourceStack, "particle_loop", message.particle_loop);
        return sourceStack;
    }
}

