/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class MidiDeviceBroadcastPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceUtils.newModLocation(MidiDeviceBroadcastPacket.class.getSimpleName().toLowerCase());
    public static final CustomPacketPayload.Type<MidiDeviceBroadcastPacket> TYPE = new CustomPacketPayload.Type(ID);
    @Nonnull
    public final MidiEventType type;
    @Nonnull
    public final Byte channel;
    @Nonnull
    public final Byte note;
    @Nonnull
    public final Byte velocity;
    @Nonnull
    public final UUID player;
    @Nonnull
    public final BlockPos pos;
    @Nonnull
    public final Long noteServerTime;

    public static MidiDeviceBroadcastPacket fromBroadcastEvent(BroadcastEvent event) {
        return new MidiDeviceBroadcastPacket(event.type, event.channel, event.note, event.velocity, event.senderId, event.pos, event.eventTime);
    }

    protected MidiDeviceBroadcastPacket(MidiEventType type, Byte channel, Byte note, Byte velocity, UUID player, BlockPos pos, Long noteServerTime) {
        this.type = type;
        this.channel = channel;
        this.note = note;
        this.velocity = velocity;
        this.player = player;
        this.pos = pos;
        this.noteServerTime = noteServerTime;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static MidiDeviceBroadcastPacket decodePacket(FriendlyByteBuf buf) {
        try {
            MidiEventType type = MidiEventType.fromByte(buf.readByte());
            byte channel = buf.readByte();
            byte note = buf.readByte();
            byte velocity = buf.readByte();
            UUID player = buf.readUUID();
            BlockPos pos = buf.readBlockPos();
            Long noteServerTime = buf.readLong();
            return new MidiDeviceBroadcastPacket(type, channel, note, velocity, player, pos, noteServerTime);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("MidiDeviceBroadcastPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
    }

    public static void encodePacket(MidiDeviceBroadcastPacket pkt, FriendlyByteBuf buf) {
        buf.writeByte((int)pkt.type.toByte().byteValue());
        buf.writeByte((int)pkt.channel.byteValue());
        buf.writeByte((int)pkt.note.byteValue());
        buf.writeByte((int)pkt.velocity.byteValue());
        buf.writeUUID(pkt.player);
        buf.writeBlockPos(pkt.pos);
        buf.writeLong(pkt.noteServerTime.longValue());
    }
}

