/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.network.NetMidiEvent;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.github.tofodroid.mods.mimi.util.NetworkUtils;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class MultiNoteEventPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceUtils.newModLocation(MultiNoteEventPacket.class.getSimpleName().toLowerCase());
    public static final CustomPacketPayload.Type<MultiNoteEventPacket> TYPE = new CustomPacketPayload.Type(ID);
    private final Map<Long, ArrayList<NetMidiEvent>> sourceMap;
    public final TreeMap<Long, List<NoteEventPacket>> resultPackets;

    public MultiNoteEventPacket(Map<Long, ArrayList<NetMidiEvent>> sourceMap) {
        this.sourceMap = new HashMap<Long, ArrayList<NetMidiEvent>>(sourceMap);
        this.resultPackets = new TreeMap();
        for (Map.Entry<Long, ArrayList<NetMidiEvent>> sourceEntry : sourceMap.entrySet()) {
            ArrayList<NoteEventPacket> packets = new ArrayList<NoteEventPacket>();
            for (NetMidiEvent event : sourceEntry.getValue()) {
                packets.add(NoteEventPacket.fromNetMidiEvent(event, sourceEntry.getKey()));
            }
            this.resultPackets.put(sourceEntry.getKey(), packets);
        }
    }

    public MultiNoteEventPacket(TreeMap<Long, List<NoteEventPacket>> packets) {
        this.resultPackets = packets;
        this.sourceMap = Map.of();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static MultiNoteEventPacket decodePacket(FriendlyByteBuf buf) {
        try {
            TreeMap<Long, List<NoteEventPacket>> resultMap = new TreeMap<Long, List<NoteEventPacket>>();
            Integer numTimes = buf.readInt();
            Integer timeIndex = 0;
            while (timeIndex < numTimes) {
                Long noteServerTime = buf.readLong();
                List timePackets = resultMap.computeIfAbsent(noteServerTime, time -> new ArrayList());
                Integer numEvents = buf.readInt();
                Integer eventIndex = 0;
                while (eventIndex < numEvents) {
                    MidiEventType type = MidiEventType.fromByte(buf.readByte());
                    Byte data1 = ByteUtils.ZERO;
                    Byte data2 = ByteUtils.ZERO;
                    if (type != MidiEventType.RESET) {
                        data1 = buf.readByte();
                    }
                    if (type != MidiEventType.RESET || type != MidiEventType.NOTE_OFF) {
                        data2 = buf.readByte();
                    }
                    UUID playerId = buf.readUUID();
                    BlockPos pos = buf.readBlockPos();
                    Byte instrumentId = buf.readByte();
                    InteractionHand instrumentHand = NetworkUtils.decodeHand(buf.readByte());
                    timePackets.add(new NoteEventPacket(type, data1, data2, instrumentId, playerId, pos, noteServerTime, instrumentHand));
                    Integer n = eventIndex;
                    eventIndex = eventIndex + 1;
                }
                Integer n = timeIndex;
                timeIndex = timeIndex + 1;
            }
            return new MultiNoteEventPacket(resultMap);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("MultiNoteEventPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
    }

    public static void encodePacket(MultiNoteEventPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.resultPackets.size());
        for (Map.Entry<Long, ArrayList<NetMidiEvent>> timeEntry : pkt.sourceMap.entrySet()) {
            if (timeEntry.getValue() == null || timeEntry.getValue().isEmpty()) continue;
            buf.writeLong(timeEntry.getKey().longValue());
            buf.writeInt(timeEntry.getValue().size());
            for (NetMidiEvent noteEvent : timeEntry.getValue()) {
                buf.writeByte((int)noteEvent.type.toByte().byteValue());
                if (noteEvent.type != MidiEventType.RESET) {
                    buf.writeByte((int)noteEvent.note.byteValue());
                }
                if (noteEvent.type != MidiEventType.RESET || noteEvent.type != MidiEventType.NOTE_OFF) {
                    buf.writeByte((int)noteEvent.velocity.byteValue());
                }
                buf.writeUUID(noteEvent.playerId);
                buf.writeBlockPos(noteEvent.pos);
                buf.writeByte((int)noteEvent.instrumentId.byteValue());
                buf.writeByte((int)NetworkUtils.encodeHand(noteEvent.instrumentHand).byteValue());
            }
        }
    }
}

