/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.server.midi.playlist.APlaylistHandler;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import io.netty.handler.codec.DecoderException;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class ServerMusicPlayerStatusPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceUtils.newModLocation(ServerMusicPlayerStatusPacket.class.getSimpleName().toLowerCase());
    public static final CustomPacketPayload.Type<ServerMusicPlayerStatusPacket> TYPE = new CustomPacketPayload.Type(ID);
    private static final UUID NO_FILE_ID = new UUID(0L, 0L);
    public final UUID musicPlayerId;
    public final UUID fileId;
    public final Integer fileIndex;
    public final Boolean isFileFavorite;
    public final byte[] channelMapping;
    public final Integer songLengthSeconds;
    public final Integer songPositionSeconds;
    public final Boolean isPlaying;
    public final Boolean isLoadFailed;
    public final Boolean isLoading;
    public final Boolean isShuffled;
    public final APlaylistHandler.LoopMode loopMode;
    public final APlaylistHandler.FavoriteMode favoriteMode;
    public final APlaylistHandler.SourceMode sourceMode;

    public ServerMusicPlayerStatusPacket(UUID musicPlayerId) {
        this.musicPlayerId = musicPlayerId;
        this.fileId = null;
        this.fileIndex = null;
        this.isFileFavorite = false;
        this.channelMapping = null;
        this.songLengthSeconds = null;
        this.songPositionSeconds = null;
        this.isPlaying = false;
        this.isLoadFailed = false;
        this.isLoading = false;
        this.isShuffled = false;
        this.loopMode = APlaylistHandler.LoopMode.ALL;
        this.favoriteMode = APlaylistHandler.FavoriteMode.ALL;
        this.sourceMode = APlaylistHandler.SourceMode.ALL;
    }

    public ServerMusicPlayerStatusPacket(UUID musicPlayerId, UUID fileId, Integer fileIndex, Boolean isFileFavorite, byte[] channelMapping, Integer songLengthSeconds, Integer songPositionSeconds, Boolean isPlaying, Boolean isLoadFailed, Boolean isLoading, Boolean isShuffled, APlaylistHandler.LoopMode loopMode, APlaylistHandler.FavoriteMode favoriteMode, APlaylistHandler.SourceMode sourceMode) {
        this.musicPlayerId = musicPlayerId;
        this.fileId = fileId;
        this.fileIndex = fileIndex;
        this.isFileFavorite = isFileFavorite;
        this.channelMapping = channelMapping;
        this.songLengthSeconds = songLengthSeconds;
        this.songPositionSeconds = songPositionSeconds;
        this.isPlaying = isPlaying;
        this.isLoadFailed = isLoadFailed;
        this.isLoading = isLoading;
        this.isShuffled = isShuffled;
        this.loopMode = loopMode;
        this.favoriteMode = favoriteMode;
        this.sourceMode = sourceMode;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static ServerMusicPlayerStatusPacket decodePacket(FriendlyByteBuf buf) {
        try {
            Integer songPositionSeconds;
            Integer fileIndex;
            UUID musicPlayerId = buf.readUUID();
            UUID fileId = buf.readUUID();
            if (fileId.toString().equals(NO_FILE_ID.toString())) {
                fileId = null;
            }
            if ((fileIndex = Integer.valueOf(buf.readByte())) < 0) {
                fileIndex = null;
            }
            Boolean isFileFavorite = buf.readBoolean();
            byte[] channelMapping = buf.readBoolean() ? buf.readByteArray(16) : null;
            Integer songLengthSeconds = buf.readInt();
            if (songLengthSeconds < 0) {
                songLengthSeconds = null;
            }
            if ((songPositionSeconds = Integer.valueOf(buf.readInt())) < 0) {
                songPositionSeconds = null;
            }
            Boolean isPlaying = buf.readBoolean();
            Boolean isLoadFailed = buf.readBoolean();
            Boolean isLoading = buf.readBoolean();
            Boolean isShuffled = buf.readBoolean();
            APlaylistHandler.LoopMode loopMode = APlaylistHandler.LoopMode.values()[buf.readByte()];
            APlaylistHandler.FavoriteMode favoritMode = APlaylistHandler.FavoriteMode.values()[buf.readByte()];
            APlaylistHandler.SourceMode sourceMode = APlaylistHandler.SourceMode.values()[buf.readByte()];
            return new ServerMusicPlayerStatusPacket(musicPlayerId, fileId, fileIndex, isFileFavorite, channelMapping, songLengthSeconds, songPositionSeconds, isPlaying, isLoadFailed, isLoading, isShuffled, loopMode, favoritMode, sourceMode);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("ServerMusicPlayerStatusPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
        catch (DecoderException e) {
            MIMIMod.LOGGER.error("ServerMusicPlayerStatusPacket contained invalid bytes. Exception: " + String.valueOf((Object)e));
            return null;
        }
    }

    public static void encodePacket(ServerMusicPlayerStatusPacket pkt, FriendlyByteBuf buf) {
        buf.writeUUID(pkt.musicPlayerId);
        buf.writeUUID(pkt.fileId != null ? pkt.fileId : NO_FILE_ID);
        buf.writeByte(pkt.fileIndex != null ? pkt.fileIndex : -1);
        buf.writeBoolean(pkt.isFileFavorite.booleanValue());
        if (pkt.channelMapping != null) {
            buf.writeBoolean(true);
            buf.writeByteArray(pkt.channelMapping);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(pkt.songLengthSeconds != null ? pkt.songLengthSeconds : -1);
        buf.writeInt(pkt.songPositionSeconds != null ? pkt.songPositionSeconds : -1);
        buf.writeBoolean(pkt.isPlaying.booleanValue());
        buf.writeBoolean(pkt.isLoadFailed.booleanValue());
        buf.writeBoolean(pkt.isLoading.booleanValue());
        buf.writeBoolean(pkt.isShuffled.booleanValue());
        buf.writeByte(pkt.loopMode.ordinal());
        buf.writeByte(pkt.favoriteMode.ordinal());
        buf.writeByte(pkt.sourceMode.ordinal());
    }
}

