/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.recipe;

import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class CloneMidiSettingsRecipe
extends CustomRecipe {
    public static final String REGISTRY_NAME = "clonemidi";
    public static final List<Item> MIDI_ITEMS = Arrays.asList(ModItems.CONDUCTOR, ModItems.LISTENER, ModItems.RECEIVER, ModItems.RELAY);
    public static final SimpleCraftingRecipeSerializer<?> SERIALIZER = new SimpleCraftingRecipeSerializer(CloneMidiSettingsRecipe::new);

    public CloneMidiSettingsRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ItemStack source = ItemStack.EMPTY;
        Integer foundSlots = 1;
        List<Integer> validSlots = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackI = inv.getItem(i);
            if (!stackI.isEmpty() && !this.canStoreMidiSettings(stackI).booleanValue()) {
                return false;
            }
            if (!stackI.isEmpty() && source.isEmpty()) {
                validSlots = this.getValidSlots(i, inv.width(), inv.height());
                if (validSlots != null) {
                    source = stackI;
                    continue;
                }
                return false;
            }
            if (source.isEmpty()) continue;
            if (validSlots.contains(i) && this.canCopyFromSourceToTarget(source, stackI).booleanValue()) {
                Integer n = foundSlots;
                foundSlots = foundSlots + 1;
                continue;
            }
            if (stackI.isEmpty() || validSlots.contains(i) && this.canCopyFromSourceToTarget(source, stackI).booleanValue()) continue;
            return false;
        }
        return !source.isEmpty() && foundSlots == 2;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider pRegistries) {
        ItemStack source = ItemStack.EMPTY;
        ItemStack target = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackI = inv.getItem(i);
            if (!stackI.isEmpty() && source.isEmpty()) {
                source = stackI;
                continue;
            }
            if (stackI.isEmpty() || source.isEmpty()) continue;
            target = stackI;
        }
        if (!source.isEmpty() && !target.isEmpty()) {
            return MidiNbtDataUtils.copyMidiSettings(source, target);
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            if (!this.canStoreMidiSettings(inv.getItem(i)).booleanValue()) continue;
            nonnulllist.set(i, (Object)inv.getItem(i).copyWithCount(1));
            break;
        }
        return nonnulllist;
    }

    protected Boolean canStoreMidiSettings(ItemStack stack) {
        return stack.getItem() instanceof IInstrumentItem || MIDI_ITEMS.contains(stack.getItem());
    }

    protected List<Integer> getValidSlots(Integer slot, Integer width, Integer height) {
        Integer slotCol = slot % height;
        if (slotCol < width - 1) {
            return Arrays.asList(slot, slot + 1);
        }
        return null;
    }

    protected Boolean canCopyFromSourceToTarget(ItemStack source, ItemStack target) {
        return source.getItem() instanceof IInstrumentItem && target.getItem() instanceof IInstrumentItem || source.getItem().equals(target.getItem());
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

