/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.recipe;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class ColoredItemRecipe
extends CustomRecipe {
    public static final String REGISTRY_NAME = "coloreditem";
    public static final SimpleCraftingRecipeSerializer<?> SERIALIZER = new SimpleCraftingRecipeSerializer(ColoredItemRecipe::new);

    public ColoredItemRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ItemStack instrument = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackI = inv.getItem(i);
            if (stackI.is(ItemTags.DYEABLE) && instrument.isEmpty()) {
                instrument = stackI;
                continue;
            }
            if (stackI.isEmpty() || stackI.getItem() instanceof DyeItem) continue;
            return false;
        }
        return !instrument.isEmpty();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider pRegistries) {
        ItemStack instrument = ItemStack.EMPTY;
        ArrayList<DyeItem> dyes = new ArrayList<DyeItem>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackI = inv.getItem(i);
            if (stackI.isEmpty()) continue;
            if (stackI.is(ItemTags.DYEABLE) && instrument.isEmpty()) {
                instrument = stackI;
                continue;
            }
            if (!(stackI.getItem() instanceof DyeItem)) continue;
            dyes.add((DyeItem)stackI.getItem());
        }
        return !instrument.isEmpty() && !dyes.isEmpty() ? DyedItemColor.applyDyes((ItemStack)instrument, dyes) : ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

