/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.recipe;

import io.github.tofodroid.mods.mimi.common.block.AColoredBlock;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class CopyBlockDyeRecipe
extends CustomRecipe {
    public static final String REGISTRY_NAME = "copyblockdye";
    public static final SimpleCraftingRecipeSerializer<?> SERIALIZER = new SimpleCraftingRecipeSerializer(CopyBlockDyeRecipe::new);

    public CopyBlockDyeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ItemStack source = ItemStack.EMPTY;
        Integer foundSlots = 1;
        List<Integer> validSlots = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackI = inv.getItem(i);
            if (!stackI.isEmpty() && !this.isAllowedItem(stackI).booleanValue()) {
                return false;
            }
            if (!stackI.isEmpty() && source.isEmpty()) {
                validSlots = this.getValidSlots(i, inv.width(), inv.height());
                if (validSlots != null) {
                    source = stackI;
                    continue;
                }
                return false;
            }
            if (source.isEmpty()) continue;
            if (validSlots.contains(i) && this.isAllowedItem(stackI).booleanValue()) {
                Integer n = foundSlots;
                foundSlots = foundSlots + 1;
                continue;
            }
            if (validSlots.contains(i) || stackI.isEmpty()) continue;
            return false;
        }
        return !source.isEmpty() && foundSlots == 2;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider pRegistries) {
        ItemStack source = ItemStack.EMPTY;
        ItemStack target = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackI = inv.getItem(i);
            if (!stackI.isEmpty() && source.isEmpty()) {
                source = stackI;
                continue;
            }
            if (stackI.isEmpty() || source.isEmpty()) continue;
            target = stackI;
        }
        if (!source.isEmpty() && !target.isEmpty()) {
            ItemStack result = target.copyWithCount(1);
            DataComponentType<Integer> DYE_COMPONENT = TagUtils.getIntComponent(AColoredBlock.DYE_ID.getName());
            result.set(DYE_COMPONENT, (Object)TagUtils.getOrDefault((DataComponentHolder)source, DYE_COMPONENT, 0));
            return result;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            if (!this.isAllowedItem(inv.getItem(i)).booleanValue()) continue;
            nonnulllist.set(i, (Object)inv.getItem(i).copyWithCount(1));
            break;
        }
        return nonnulllist;
    }

    protected List<Integer> getValidSlots(Integer slot, Integer width, Integer height) {
        Integer slotCol = slot % height;
        if (slotCol < width - 1) {
            return Arrays.asList(slot, slot + 1);
        }
        return null;
    }

    protected Boolean isAllowedItem(ItemStack stack) {
        return stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() instanceof AColoredBlock;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

