/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.tofodroid.mods.mimi.common.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class TuningTableRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient instrument;
    private final Ingredient addition;
    private final ItemStack result;

    public TuningTableRecipe(Ingredient instrument, Ingredient addition, ItemStack result) {
        this.instrument = instrument;
        this.addition = addition;
        this.result = result;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        return this.instrument.test(inv.getItem(0)) && this.addition.test(inv.getItem(1));
    }

    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Blocks.SMITHING_TABLE);
    }

    public String getGroup() {
        return "";
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return ModRecipes.TUNING_TYPE;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        return NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList result = NonNullList.create();
        result.add(0, (Object)this.instrument);
        result.add(1, (Object)this.addition);
        return result;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider pRegistries) {
        ItemStack itemstack = this.result.copy();
        itemstack.applyComponents(inv.getItem(0).getComponents());
        return itemstack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getResultItem(HolderLookup.Provider r) {
        return this.result;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<TuningTableRecipe> {
        public static final String REGISTRY_NAME = "tuning";

        public StreamCodec<RegistryFriendlyByteBuf, TuningTableRecipe> streamCodec() {
            return StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        }

        public MapCodec<TuningTableRecipe> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("instrument").forGetter(o -> o.instrument), (App)Ingredient.CODEC.fieldOf("addition").forGetter(o -> o.addition), (App)ItemStack.CODEC.fieldOf("result").forGetter(o -> o.result)).apply((Applicative)instance, TuningTableRecipe::new));
        }

        public static TuningTableRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient ingredient1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new TuningTableRecipe(ingredient, ingredient1, itemstack);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, TuningTableRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.instrument);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.addition);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

