/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableMidiPowerSourceBlock;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableMidiNoteResponsiveTile;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AConfigurableMidiPowerSourceTile
extends AConfigurableMidiNoteResponsiveTile {
    public static final Integer MAX_NOTE_ON_SECONDS = 10;
    protected Map<Integer, Long> heldNotes = new Int2LongArrayMap();
    protected List<Integer> notesToTurnOff = new ArrayList<Integer>();
    protected Boolean noteHeld = false;
    protected Integer offCounter = 0;
    protected Boolean triggerHeld = false;
    protected Byte holdTicks = 0;

    public AConfigurableMidiPowerSourceTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1);
    }

    protected AConfigurableMidiPowerSourceTile(BlockEntityType<?> type, BlockPos pos, BlockState state, Integer inventorySize) {
        super(type, pos, state, inventorySize);
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        if (!this.getLevel().isClientSide()) {
            this.offCounter = 0;
        }
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.getLevel().isClientSide()) {
            this.offCounter = 0;
        }
    }

    @Override
    protected void cacheMidiSettings() {
        super.cacheMidiSettings();
        this.setInverted(MidiNbtDataUtils.getInvertSignal(this.getSourceStack()));
        this.triggerHeld = MidiNbtDataUtils.getTriggerNoteStart(this.getSourceStack()) == false;
        this.holdTicks = MidiNbtDataUtils.getHoldTicks(this.getSourceStack());
        this.noteHeld = false;
        this.clearNotes();
    }

    @Override
    public void execServerTick(ServerLevel world, BlockPos pos, BlockState state) {
        if (this.isBlockValid().booleanValue()) {
            Boolean shouldBePowered = this.noteHeld;
            if (shouldBePowered.booleanValue()) {
                this.setPowered(true);
                this.offCounter = 0;
            } else if (((Boolean)state.getValue((Property)AConfigurableMidiPowerSourceBlock.POWERED)).booleanValue()) {
                if (this.offCounter >= this.holdTicks - 1) {
                    this.offCounter = 0;
                    this.setPowered(false);
                } else {
                    Integer n = this.offCounter;
                    this.offCounter = this.offCounter + 1;
                }
            }
            this.noteHeld = this.tickNotes();
        }
    }

    public Boolean isHeld() {
        return this.triggerHeld != false && this.noteHeld != false;
    }

    public Boolean isBlockValid() {
        return this.getBlockState().getBlock() instanceof AConfigurableMidiPowerSourceBlock;
    }

    public Boolean isPowered() {
        return (Boolean)this.getBlockState().getValue((Property)AConfigurableMidiPowerSourceBlock.POWERED);
    }

    public Boolean isInverted() {
        return (Boolean)this.getBlockState().getValue((Property)AConfigurableMidiPowerSourceBlock.INVERTED);
    }

    public Boolean stackIsInverted() {
        return MidiNbtDataUtils.getInvertSignal(this.getSourceStack());
    }

    public void setInverted(Boolean inverted) {
        if (this.getBlockState().getValue((Property)AConfigurableMidiPowerSourceBlock.INVERTED) != inverted) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)AConfigurableMidiPowerSourceBlock.INVERTED, (Comparable)inverted));
            this.getLevel().updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        }
    }

    public void setPowered(Boolean powered) {
        if (this.getBlockState().getValue((Property)AConfigurableMidiPowerSourceBlock.POWERED) != powered) {
            if (!this.isValid().booleanValue()) {
                return;
            }
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)AConfigurableMidiPowerSourceBlock.POWERED, (Comparable)powered));
            this.getLevel().updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        }
    }

    protected Integer getUniqueNoteInt(Byte group, Byte note) {
        return group * 128 + note;
    }

    protected Boolean tickNotes() {
        if (this.triggerHeld.booleanValue()) {
            ArrayList<Integer> notesToRemove = new ArrayList<Integer>();
            Long nowTime = Instant.now().toEpochMilli();
            for (Integer noteId : this.heldNotes.keySet()) {
                if (!this.notesToTurnOff.contains(noteId) && nowTime - this.heldNotes.get(noteId) < (long)(MAX_NOTE_ON_SECONDS * 1000)) continue;
                notesToRemove.add(noteId);
            }
            for (Integer noteId : notesToRemove) {
                this.heldNotes.remove(noteId);
            }
            this.notesToTurnOff.clear();
            return !this.heldNotes.isEmpty();
        }
        this.clearNotes();
        return false;
    }

    protected void clearNotes() {
        this.heldNotes.clear();
        this.notesToTurnOff.clear();
    }

    protected Boolean hasNotesOn() {
        return !this.heldNotes.isEmpty();
    }

    @Override
    public void onNoteOn(@Nullable Byte channel, @Nonnull Byte note, @Nonnull Byte velocity, @Nullable Byte instrumentId, Long noteTime) {
        Integer noteId = this.getUniqueNoteInt(this.getNoteGroupKey(channel, instrumentId), note);
        this.heldNotes.put(noteId, Instant.now().toEpochMilli());
        this.notesToTurnOff.remove(noteId);
        this.noteHeld = true;
    }

    @Override
    public void onNoteOff(@Nullable Byte channel, @Nonnull Byte note, @Nonnull Byte velocity, @Nullable Byte instrumentId, Long noteTime) {
        if (this.triggerHeld.booleanValue() && this.noteHeld.booleanValue()) {
            Integer noteId = this.getUniqueNoteInt(this.getNoteGroupKey(channel, instrumentId), note);
            this.notesToTurnOff.add(noteId);
        }
    }

    @Override
    public void onReset(@Nullable Byte channel, @Nullable Byte instrumentId, Long noteTime) {
        if (this.triggerHeld.booleanValue()) {
            Byte groupKey = this.getNoteGroupKey(channel, instrumentId);
            if (groupKey == null || channel != null && channel == BroadcastEvent.ALL_CHANNELS) {
                this.clearNotes();
            } else if (groupKey != null) {
                for (Integer noteId : this.heldNotes.keySet()) {
                    if (noteId / 128 != groupKey) continue;
                    this.notesToTurnOff.add(noteId);
                }
            }
        }
    }

    public abstract Byte getNoteGroupKey(@Nullable Byte var1, @Nullable Byte var2);
}

