/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.tile.AConfigurableTile;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AConfigurableMidiTile
extends AConfigurableTile {
    protected UUID id;

    public AConfigurableMidiTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1);
    }

    protected AConfigurableMidiTile(BlockEntityType<?> type, BlockPos pos, BlockState state, Integer inventorySize) {
        super(type, pos, state, inventorySize);
    }

    protected Boolean isValid() {
        return !this.isRemoved() && this.level != null;
    }

    @Override
    public void loadItems(CompoundTag compound, HolderLookup.Provider pRegistries) {
        CompoundTag stackTag;
        String itemId;
        ListTag listtag = compound.getList("Items", 10);
        ItemStack convertStack = null;
        if (listtag.size() > 0 && (itemId = (stackTag = listtag.getCompound(0)).getString("id")).equalsIgnoreCase("mimi:switchboard")) {
            convertStack = this.initializeSourceStack(MidiNbtDataUtils.convertSwitchboardToDataTag(stackTag.getCompound("tag")));
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, (NonNullList)this.items, (HolderLookup.Provider)pRegistries);
        if (convertStack != null) {
            this.setSourceStack(convertStack);
        }
    }

    public UUID getUUID() {
        if (this.id == null) {
            String idString = ((Object)((Object)this)).getClass().getSimpleName() + this.getBlockPos().getX() + "-" + this.getBlockPos().getY() + "-" + this.getBlockPos().getZ();
            this.id = UUID.nameUUIDFromBytes(idString.getBytes());
        }
        return this.id;
    }
}

