/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.tile.AStaticInventoryTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AConfigurableTile
extends AStaticInventoryTile {
    public static final Integer SOURCE_STACK_SLOT = 0;

    public AConfigurableTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1);
    }

    protected AConfigurableTile(BlockEntityType<?> type, BlockPos pos, BlockState state, Integer inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public void setSourceStack(ItemStack stack) {
        if (stack.getItem().getClass().equals(this.getBlockState().getBlock().asItem().getClass())) {
            this.setItem(SOURCE_STACK_SLOT, stack);
            this.onSourceStackChanged();
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    protected void onSourceStackChanged() {
    }

    public ItemStack getSourceStack() {
        if (this.items.isEmpty() || this.items.get(0) == null) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(SOURCE_STACK_SLOT.intValue());
    }

    @Override
    public void onItemsLoaded() {
        if (((ItemStack)this.items.get(0)).isEmpty()) {
            MIMIMod.LOGGER.warn(((Object)((Object)this)).getClass().getSimpleName() + " is missing stack! Re-initializing.");
            this.initializeSourceStack(null);
        }
    }

    protected ItemStack initializeSourceStack(CompoundTag stackTag) {
        ItemStack sourceStack = new ItemStack((ItemLike)this.getBlockState().getBlock().asItem(), 1);
        return sourceStack;
    }
}

