/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AStaticInventoryTile
extends BlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    protected final Integer INVENTORY_SIZE;
    protected NonNullList<ItemStack> items;

    public AStaticInventoryTile(BlockEntityType<?> type, BlockPos pos, BlockState state, Integer inventorySize) {
        super(type, pos, state);
        this.INVENTORY_SIZE = inventorySize;
        this.items = inventorySize > 0 ? NonNullList.withSize((int)this.INVENTORY_SIZE, (Object)ItemStack.EMPTY) : NonNullList.withSize((int)0, (Object)ItemStack.EMPTY);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.saveAdditional(nbt, pRegistries);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.loadItems(nbt, pRegistries);
    }

    public void loadItems(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)pRegistries);
        this.onItemsLoaded();
    }

    public void onItemsLoaded() {
    }

    public int getContainerSize() {
        return this.INVENTORY_SIZE;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public ItemStack getItem(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack removeItem(int i, int count) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int i) {
        return ItemStack.EMPTY;
    }

    public void setItem(int i, ItemStack item) {
        this.items.set(i, (Object)item);
        if (item.getCount() > this.getMaxStackSize()) {
            item.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public boolean stillValid(Player playerEntity) {
        if (this.level != null && this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(playerEntity.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public void dropContent() {
        this.getItems().forEach(stack -> Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)stack));
        this.clearContent();
    }

    public void clearContent() {
        this.getItems().clear();
    }

    public int[] getSlotsForFace(Direction p_19238_) {
        return new int[0];
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveCustomOnly(pRegistries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void fillStackedContents(StackedContents helper) {
        for (ItemStack itemstack : this.items) {
            helper.accountStack(itemstack);
        }
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        return false;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
        return false;
    }
}

