/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.registry.RegistryOverrideProxy;
import io.github.tofodroid.mods.mimi.common.tile.TileConductor;
import io.github.tofodroid.mods.mimi.common.tile.TileEffectEmitter;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.common.tile.TileListener;
import io.github.tofodroid.mods.mimi.common.tile.TileMechanicalMaestro;
import io.github.tofodroid.mods.mimi.common.tile.TileReceiver;
import io.github.tofodroid.mods.mimi.common.tile.TileRelay;
import io.github.tofodroid.mods.mimi.common.tile.TileTransmitter;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ModTiles {
    public static final Map<ResourceLocation, BlockEntityType<?>> BLOCK_ENTITIES = new HashMap();
    public static BlockEntityType<TileInstrument> INSTRUMENT = ModTiles.create("instrument", TileInstrument::new, (Block[])ModBlocks.INSTRUMENTS.toArray(new BlockInstrument[ModBlocks.INSTRUMENTS.size()]));
    public static BlockEntityType<TileTransmitter> TRANSMITTER = ModTiles.create("transmitter", TileTransmitter::new, new Block[]{ModBlocks.TRANSMITTERBLOCK});
    public static BlockEntityType<TileListener> LISTENER = ModTiles.create("listener", TileListener::new, new Block[]{ModBlocks.LISTENER});
    public static BlockEntityType<TileReceiver> RECEIVER = ModTiles.create("receiver", TileReceiver::new, new Block[]{ModBlocks.RECEIVER});
    public static BlockEntityType<TileConductor> CONDUCTOR = ModTiles.create("conductor", TileConductor::new, new Block[]{ModBlocks.CONDUCTOR});
    public static BlockEntityType<TileMechanicalMaestro> MECHANICALMAESTRO = ModTiles.create("mechanicalmaestro", TileMechanicalMaestro::new, new Block[]{ModBlocks.MECHANICALMAESTRO});
    public static BlockEntityType<TileEffectEmitter> EFFECTEMITTER = ModTiles.create("effectemitter", TileEffectEmitter::new, new Block[]{ModBlocks.EFFECTEMITTER});
    public static BlockEntityType<TileRelay> RELAY = ModTiles.create("relay", TileRelay::new, new Block[]{ModBlocks.RELAY});

    private static <T extends BlockEntity> BlockEntityType<T> create(String id, BlockEntityType.BlockEntitySupplier<T> blockEntity, Block ... blocks) {
        blockEntity = RegistryOverrideProxy.getOrOverride(BlockEntityType.BlockEntitySupplier.class, id, blockEntity);
        BlockEntityType type = BlockEntityType.Builder.of(blockEntity, (Block[])blocks).build(null);
        BLOCK_ENTITIES.put(ResourceUtils.newModLocation(id), type);
        return type;
    }
}

