/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.block.BlockEffectEmitter;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableTile;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3d;

public class TileEffectEmitter
extends AConfigurableTile {
    public static final String REGISTRY_NAME = "effectemitter";
    public static final String INVERTED_TAG = "invert_signal";
    public static final String SOUND_ID_TAG = "sound";
    public static final String PARTICLE_ID_TAG = "particle";
    public static final String VOLUME_TAG = "volume";
    public static final String PITCH_TAG = "pitch";
    public static final String SIDE_TAG = "side";
    public static final String SPREAD_TAG = "spread";
    public static final String COUNT_TAG = "count";
    public static final String SPEED_X_TAG = "speed_x";
    public static final String SPEED_Y_TAG = "speed_y";
    public static final String SPEED_Z_TAG = "speed_z";
    public static final String PARTICLE_LOOP_TAG = "particle_loop";
    public static final String SOUND_LOOP_TAG = "sound_loop";
    private Boolean _inverted = null;
    private SoundEvent _sound = null;
    private Float _volume = null;
    private Float _pitch = null;
    private ParticleOptions _particle = null;
    private Vector3d _offset = null;
    private Vector3d _speed = null;
    private Integer _spread = null;
    private Integer _count = null;
    private Integer _soundLoop = null;
    private Integer _particleLoop = null;
    private Boolean firstTick = true;
    private Integer ticksSinceSound = 0;
    private Integer ticksSinceParticle = 0;
    private Boolean wasPowered;
    private Boolean wasInverted;

    public TileEffectEmitter(BlockPos pos, BlockState state) {
        super(ModTiles.EFFECTEMITTER, pos, state, 1);
        this.wasPowered = (Boolean)state.getValue((Property)BlockEffectEmitter.POWERED);
        this.wasInverted = (Boolean)state.getValue((Property)BlockEffectEmitter.INVERTED);
    }

    @Override
    protected void onSourceStackChanged() {
        this.ticksSinceSound = 0;
        this.ticksSinceParticle = 0;
        this.cacheEffectSettings();
        this.updateBlockstate();
        this.setChanged();
    }

    protected void cacheEffectSettings() {
        this._inverted = TagUtils.getBooleanOrDefault((DataComponentHolder)this.getSourceStack(), INVERTED_TAG, false);
        this._particle = this.getParticleFromString(TagUtils.getStringOrDefault((DataComponentHolder)this.getSourceStack(), PARTICLE_ID_TAG, null));
        this._speed = new Vector3d((double)((float)TagUtils.getByteOrDefault(this.getSourceStack(), SPEED_X_TAG, 0).byteValue() / 40.0f), (double)((float)TagUtils.getByteOrDefault(this.getSourceStack(), SPEED_Y_TAG, 0).byteValue() / 40.0f), (double)((float)TagUtils.getByteOrDefault(this.getSourceStack(), SPEED_Z_TAG, 0).byteValue() / 40.0f));
        this._offset = this.getOffsetFromByte(TagUtils.getByteOrDefault(this.getSourceStack(), SIDE_TAG, 0));
        this._spread = TagUtils.getByteOrDefault(this.getSourceStack(), SPREAD_TAG, 0).intValue();
        this._count = TagUtils.getByteOrDefault(this.getSourceStack(), COUNT_TAG, 1).intValue();
        this._soundLoop = TagUtils.getIntOrDefault((DataComponentHolder)this.getSourceStack(), SOUND_LOOP_TAG, 0);
        this._particleLoop = TagUtils.getIntOrDefault((DataComponentHolder)this.getSourceStack(), PARTICLE_LOOP_TAG, 0);
        this._sound = this.getSoundFromString(TagUtils.getStringOrDefault((DataComponentHolder)this.getSourceStack(), SOUND_ID_TAG, null));
        this._volume = Float.valueOf(5.0f * ((float)TagUtils.getByteOrDefault(this.getSourceStack(), VOLUME_TAG, 5).byteValue() / 10.0f));
        this._pitch = Float.valueOf(1.0f + (float)TagUtils.getByteOrDefault(this.getSourceStack(), PITCH_TAG, 0).byteValue() / 4.0f);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        if (this.level != null && this.getBlockState() != null) {
            if (this.level.isClientSide) {
                if (this.wasPowered != this.getBlockState().getValue((Property)BlockEffectEmitter.POWERED) || this.wasInverted != this.getBlockState().getValue((Property)BlockEffectEmitter.INVERTED)) {
                    this.wasPowered = (Boolean)this.getBlockState().getValue((Property)BlockEffectEmitter.POWERED);
                    this.wasInverted = (Boolean)this.getBlockState().getValue((Property)BlockEffectEmitter.INVERTED);
                    if (this.wasPowered != this.isInverted()) {
                        this.playParticleLocal();
                        this.playSoundLocal();
                    }
                }
            } else {
                this.updateBlockstate();
            }
        }
        this.cacheEffectSettings();
    }

    public void updateBlockstate() {
        if (this.level != null && this.getBlockState() != null && !this.level.isClientSide) {
            BlockState current = this.getBlockState();
            if (this.isInverted() != current.getValue((Property)BlockEffectEmitter.INVERTED)) {
                this.level.setBlock(this.getBlockPos(), (BlockState)current.cycle((Property)BlockEffectEmitter.INVERTED), 2);
            }
        }
    }

    public static void doTick(Level world, BlockPos pos, BlockState state, TileEffectEmitter self) {
        self.tick(world, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        Boolean powered;
        if (world instanceof ServerLevel && this.firstTick.booleanValue()) {
            this.cacheEffectSettings();
            this.firstTick = false;
        }
        if (world.isClientSide && !this.isRemoved() && world.isLoaded(pos) && (powered = (Boolean)state.getValue((Property)BlockEffectEmitter.POWERED)) != this.isInverted()) {
            Integer n;
            if (this.getSoundLoopTicks() > 0) {
                n = this.ticksSinceSound;
                this.ticksSinceSound = this.ticksSinceSound + 1;
                if (this.ticksSinceSound >= this.getSoundLoopTicks()) {
                    this.playSoundLocal();
                    this.ticksSinceSound = 0;
                }
            }
            if (this.getParticleLoopTicks() > 0) {
                n = this.ticksSinceParticle;
                this.ticksSinceParticle = this.ticksSinceParticle + 1;
                if (this.ticksSinceParticle >= this.getParticleLoopTicks()) {
                    this.playParticleLocal();
                    this.ticksSinceParticle = 0;
                }
            }
        }
    }

    public Boolean isInverted() {
        return this._inverted;
    }

    public ParticleOptions getParticleFromString(String particleStr) {
        if (particleStr != null && !particleStr.isBlank()) {
            Boolean particleValid = false;
            ParticleOptions options = null;
            try {
                options = (ParticleOptions)((Registry)this.level.registryAccess().registry(Registries.PARTICLE_TYPE).get()).get(ResourceUtils.parseLocation(particleStr));
                particleValid = options != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (particleValid.booleanValue()) {
                return options;
            }
        }
        return null;
    }

    public SoundEvent getSoundFromString(String soundStr) {
        if (soundStr != null && !soundStr.isBlank()) {
            Boolean soundValid = false;
            try {
                soundValid = ((Registry)this.level.registryAccess().registry(Registries.SOUND_EVENT).get()).containsKey(ResourceUtils.parseLocation(soundStr));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (soundValid.booleanValue()) {
                return SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceUtils.parseLocation(soundStr));
            }
        }
        return null;
    }

    public ParticleOptions getParticle() {
        return this._particle;
    }

    public SoundEvent getSound() {
        return this._sound;
    }

    public Float getVolume() {
        return this._volume;
    }

    public Float getPitch() {
        return this._pitch;
    }

    public Vector3d getSpeed() {
        return this._speed;
    }

    public Vector3d getOffsetFromByte(Byte sideByte) {
        switch (sideByte) {
            default: {
                return new Vector3d(0.5, 1.1, 0.5);
            }
            case 1: {
                return new Vector3d(0.5, -0.1, 0.5);
            }
            case 2: {
                return new Vector3d(0.5, 0.5, -0.1);
            }
            case 3: {
                return new Vector3d(1.1, 0.5, 0.5);
            }
            case 4: {
                return new Vector3d(0.5, 0.5, 1.1);
            }
            case 5: 
        }
        return new Vector3d(-0.1, 0.5, 0.5);
    }

    public Vector3d getOffset() {
        return this._offset;
    }

    public Integer getSpread() {
        return this._spread;
    }

    public Integer getCount() {
        return this._count;
    }

    public Integer getSoundLoopTicks() {
        return this._soundLoop;
    }

    public Integer getParticleLoopTicks() {
        return this._particleLoop;
    }

    public void playSoundLocal() {
        SoundEvent sound = this.getSound();
        if (sound != null && this.level.isClientSide) {
            this.getLevel().playLocalSound(this.getBlockPos(), sound, SoundSource.BLOCKS, this.getVolume().floatValue(), this.getPitch().floatValue(), false);
        }
    }

    public void playParticleLocal() {
        ParticleOptions particle = this.getParticle();
        if (particle != null && this.level.isClientSide) {
            for (int i = 0; i < this.getCount(); ++i) {
                this.getLevel().addAlwaysVisibleParticle(particle, this.getParticlePositionDim(this.getBlockPos().getX(), this.getOffset().x, this.getSpread(), this.level.getRandom()).doubleValue(), this.getParticlePositionDim(this.getBlockPos().getY(), this.getOffset().y, this.getSpread(), this.level.getRandom()).doubleValue(), this.getParticlePositionDim(this.getBlockPos().getZ(), this.getOffset().z, this.getSpread(), this.level.getRandom()).doubleValue(), this.getSpeed().x, this.getSpeed().y, this.getSpeed().z);
            }
        }
    }

    protected Double getParticlePositionDim(Integer blockPosDim, Double sideOffsetDim, Integer spread, RandomSource random) {
        if (sideOffsetDim <= 0.0 || sideOffsetDim >= 1.0) {
            return (double)blockPosDim.intValue() + sideOffsetDim;
        }
        return (double)blockPosDim.intValue() + sideOffsetDim + (random.nextBoolean() ? 1.0 : -1.0) * (double)random.nextIntBetweenInclusive(0, spread.intValue()) / 10.0;
    }
}

