/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableMidiPowerSourceTile;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.server.events.note.api.INoteConsumer;
import io.github.tofodroid.mods.mimi.server.events.note.consumer.ServerNoteConsumerManager;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TileListener
extends AConfigurableMidiPowerSourceTile
implements INoteConsumer {
    public static final String REGISTRY_NAME = "listener";

    public TileListener(BlockPos pos, BlockState state) {
        super(ModTiles.LISTENER, pos, state);
    }

    @Override
    protected void tick(Level world, BlockPos pos, BlockState state) {
        super.tick(world, pos, state);
    }

    @Override
    public void cacheMidiSettings() {
        super.cacheMidiSettings();
        if (this.hasLevel() && !this.getLevel().isClientSide) {
            ServerNoteConsumerManager.loadListenerTileConsumer(this);
        }
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        if (!this.getLevel().isClientSide()) {
            ServerNoteConsumerManager.removeConsumers(this.getUUID());
        }
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.getLevel().isClientSide()) {
            ServerNoteConsumerManager.removeConsumers(this.getUUID());
        }
    }

    @Override
    public Byte getNoteGroupKey(Byte channel, Byte instrumentId) {
        return instrumentId;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.getLevel().dimension();
    }

    @Override
    public void tickConsumer() {
    }

    @Override
    public void onConsumerRemoved() {
    }

    @Override
    public void doHandleEvent(NoteEvent message) {
        switch (message.type) {
            case NOTE_ON: {
                this.onNoteOn(null, message.note, message.velocity, message.instrumentId, message.eventTime);
                break;
            }
            case NOTE_OFF: {
                this.onNoteOff(null, message.note, message.velocity, message.instrumentId, message.eventTime);
                break;
            }
            case RESET: {
                this.onReset(null, message.instrumentId, message.eventTime);
                break;
            }
        }
    }

    @Override
    public Boolean willHandleEvent(NoteEvent message) {
        switch (message.type) {
            case NOTE_ON: {
                return message.note == null || MidiNbtDataUtils.isNoteFiltered(this.filterNote, this.filterOctMin, this.filterOctMax, this.invertFilterNoteOct, message.note) != false;
            }
            case NOTE_OFF: {
                return this.isHeld() != false && (message.note == null || MidiNbtDataUtils.isNoteFiltered(this.filterNote, this.filterOctMin, this.filterOctMax, this.invertFilterNoteOct, message.note) != false);
            }
            case RESET: {
                return this.isHeld();
            }
        }
        return false;
    }

    @Override
    public Byte getInstrumentId() {
        return this.getFilteredInstrument();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.worldPosition;
    }
}

