/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastConsumerInventoryHolder;
import io.github.tofodroid.mods.mimi.common.block.BlockMechanicalMaestro;
import io.github.tofodroid.mods.mimi.common.container.ContainerMechanicalMaestro;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.common.tile.AContainerTile;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.server.events.broadcast.consumer.instrument.InstrumentBroadcastConsumer;
import io.github.tofodroid.mods.mimi.server.events.note.consumer.ServerNoteConsumerManager;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileMechanicalMaestro
extends AContainerTile {
    public static final String REGISTRY_NAME = "mechanicalmaestro";
    private UUID id;

    public TileMechanicalMaestro(BlockPos pos, BlockState state) {
        super(ModTiles.MECHANICALMAESTRO, pos, state, 3);
    }

    public UUID getUUID() {
        if (this.id == null) {
            String idString = ((Object)((Object)this)).getClass().getSimpleName() + this.getBlockPos().getX() + "-" + this.getBlockPos().getY() + "-" + this.getBlockPos().getZ();
            this.id = UUID.nameUUIDFromBytes(idString.getBytes());
        }
        return this.id;
    }

    public Component getDefaultName() {
        return Component.translatable((String)this.getBlockState().getBlock().asItem().getDescriptionId());
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new ContainerMechanicalMaestro(id, playerInventory, (Container)this);
    }

    @Override
    public void setItem(int i, ItemStack item) {
        ItemStack oldStack = this.getItem(i);
        if (!oldStack.isEmpty()) {
            this.reset(((IInstrumentItem)oldStack.getItem()).getInstrumentId());
        }
        super.setItem(i, item);
        this.refreshMidiReceivers();
    }

    @Override
    public ItemStack removeItem(int i, int count) {
        ItemStack result = super.removeItem(i, count);
        this.reset(((IInstrumentItem)result.getItem()).getInstrumentId());
        this.refreshMidiReceivers();
        return result;
    }

    @Override
    public ItemStack removeItemNoUpdate(int i) {
        ItemStack result = super.removeItemNoUpdate(i);
        this.reset(((IInstrumentItem)result.getItem()).getInstrumentId());
        this.refreshMidiReceivers();
        return result;
    }

    @Override
    public void clearContent() {
        this.reset();
        super.clearContent();
        BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
    }

    @Override
    public void onAddedToLevel() {
        this.refreshMidiReceivers();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.refreshMidiReceivers();
    }

    public void onLoad() {
        super.onLoad();
        this.refreshMidiReceivers();
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.getLevel().isClientSide()) {
            this.reset();
            BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.getLevel().isClientSide()) {
            this.reset();
            BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
        }
    }

    @Override
    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
        return stack.getItem() instanceof IInstrumentItem;
    }

    public List<ItemStack> getInstrumentStacks() {
        return this.getItems().stream().filter(stack -> stack.getItem() instanceof IInstrumentItem).collect(Collectors.toList());
    }

    public Boolean hasAnInstrument() {
        return this.getItems().stream().anyMatch(i -> i.getItem() instanceof IInstrumentItem);
    }

    public void reset() {
        this.getItems().stream().forEach(i -> {
            if (i.getItem() instanceof IInstrumentItem) {
                this.reset(((IInstrumentItem)i.getItem()).getInstrumentId());
            }
        });
    }

    public void reset(Byte instrumentId) {
        if (instrumentId != null && this.getLevel() instanceof ServerLevel) {
            ServerNoteConsumerManager.handlePacket(NoteEventPacket.createResetPacket(instrumentId, this.getUUID(), this.getBlockPos(), null), false, this.getUUID(), (ServerLevel)this.getLevel());
        }
    }

    public void refreshMidiReceivers() {
        if (this.hasLevel() && !this.level.isClientSide) {
            if (this.hasAnInstrument().booleanValue() && ((Boolean)this.getBlockState().getValue((Property)BlockMechanicalMaestro.POWERED)).booleanValue()) {
                BroadcastConsumerInventoryHolder holder = new BroadcastConsumerInventoryHolder(this.getUUID());
                for (int i = 0; i < this.getInstrumentStacks().size(); ++i) {
                    ItemStack instrumentStack = this.getInstrumentStacks().get(i);
                    if (instrumentStack == null || MidiNbtDataUtils.getMidiSource(instrumentStack) == null) continue;
                    holder.putConsumer(i, new InstrumentBroadcastConsumer(this.getBlockPos(), (ResourceKey<Level>)this.getLevel().dimension(), this.getUUID(), instrumentStack, null));
                }
                BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
                BroadcastManager.registerConsumers(holder);
            } else {
                this.reset();
                BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
            }
        }
    }
}

