/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.block.BlockTransmitter;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableMidiTile;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.ServerTransmitterManager;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileTransmitter
extends AConfigurableMidiTile {
    public static final String REGISTRY_NAME = "transmitter";
    private UUID id;

    public TileTransmitter(BlockPos pos, BlockState state) {
        super(ModTiles.TRANSMITTER, pos, state, 1);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        if (this.hasLevel() && !this.getLevel().isClientSide && !this.getSourceStack().isEmpty()) {
            ServerTransmitterManager.createTransmitter(this);
            this.setUnpowered();
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.hasLevel() && !this.getLevel().isClientSide && !this.getSourceStack().isEmpty()) {
            ServerTransmitterManager.createTransmitter(this);
            this.setUnpowered();
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.getLevel().isClientSide()) {
            BroadcastManager.removeBroadcastProducer(this.getUUID());
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.getLevel().isClientSide()) {
            BroadcastManager.removeBroadcastProducer(this.getUUID());
        }
    }

    @Override
    public UUID getUUID() {
        if (this.id == null) {
            String idString = "tile-transmitter-" + this.getBlockPos().getX() + "-" + this.getBlockPos().getY() + "-" + this.getBlockPos().getZ();
            this.id = UUID.nameUUIDFromBytes(idString.getBytes());
        }
        return this.id;
    }

    public Boolean isPowered() {
        return (Boolean)this.getBlockState().getValue((Property)BlockTransmitter.POWERED);
    }

    public void setPowered() {
        this.setPowerAndUpdate(true);
    }

    public void setUnpowered() {
        this.setPowerAndUpdate(false);
    }

    protected void setPowerAndUpdate(Boolean powered) {
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockTransmitter.POWERED, (Comparable)powered));
        this.getLevel().updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
    }
}

