/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.forge.client;

import io.github.tofodroid.mods.mimi.client.gui.GuiMechanicalMaestroContainerScreen;
import io.github.tofodroid.mods.mimi.client.gui.GuiTuningTableContainerScreen;
import io.github.tofodroid.mods.mimi.client.renderer.EntityNoteResponseTileRenderer;
import io.github.tofodroid.mods.mimi.client.renderer.EntitySeatRenderer;
import io.github.tofodroid.mods.mimi.common.block.AColoredBlock;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.container.ModContainers;
import io.github.tofodroid.mods.mimi.common.entity.ModEntities;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.keybind.ModBindings;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="mimi", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRegistrationHandler {
    @SubscribeEvent
    public static void register(FMLClientSetupEvent event) {
        MenuScreens.register(ModContainers.TUNINGTABLE, GuiTuningTableContainerScreen::new);
        MenuScreens.register(ModContainers.MECHANICALMAESTRO, GuiMechanicalMaestroContainerScreen::new);
    }

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        for (KeyMapping bind : ModBindings.REGISTRANTS) {
            event.register(bind);
        }
    }

    @SubscribeEvent
    public static void register(RegisterColorHandlersEvent.Item event) {
        ClientRegistrationHandler.registerDyeableItemColors(event, ModItems.INSTRUMENT_ITEMS.stream().filter(i -> i.getDefaultColor() != null).collect(Collectors.toList()));
        ClientRegistrationHandler.registerDyeableItemColors(event, ModItems.BLOCK_INSTRUMENT_ITEMS.stream().filter(i -> i.getDefaultColor() != null).collect(Collectors.toList()));
        ClientRegistrationHandler.registerIDyeableItemColors(event, Arrays.asList(ModItems.LEDCUBE_A, ModItems.LEDCUBE_B, ModItems.LEDCUBE_C, ModItems.LEDCUBE_D, ModItems.LEDCUBE_E, ModItems.LEDCUBE_F, ModItems.LEDCUBE_G, ModItems.LEDCUBE_H));
    }

    @SubscribeEvent
    public static void register(RegisterColorHandlersEvent.Block event) {
        ClientRegistrationHandler.registerInstrumentBlockColors(event);
        ClientRegistrationHandler.registerAColoredBlockColors(event, Arrays.asList(ModBlocks.LEDCUBE_A, ModBlocks.LEDCUBE_B, ModBlocks.LEDCUBE_C, ModBlocks.LEDCUBE_D, ModBlocks.LEDCUBE_E, ModBlocks.LEDCUBE_F, ModBlocks.LEDCUBE_G, ModBlocks.LEDCUBE_H));
    }

    @SubscribeEvent
    public static void register(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntities.SEAT, EntitySeatRenderer::new);
        event.registerEntityRenderer(ModEntities.NOTERESPONSIVETILE, EntityNoteResponseTileRenderer::new);
    }

    protected static void registerDyeableItemColors(RegisterColorHandlersEvent.Item event, List<? extends IInstrumentItem> items) {
        event.getItemColors().register((stack, color) -> color > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)FastColor.ARGB32.opaque((int)((IInstrumentItem)stack.getItem()).getDefaultColor())), (ItemLike[])items.toArray(new Item[items.size()]));
    }

    protected static void registerInstrumentBlockColors(RegisterColorHandlersEvent.Block event) {
        List<Block> blocks = ModBlocks.INSTRUMENTS.stream().filter(i -> i.getDefaultColor() != null).collect(Collectors.toList());
        event.getBlockColors().register((state, reader, pos, color) -> reader != null && pos != null && reader.getBlockEntity(pos) != null && reader.getBlockEntity(pos) instanceof TileInstrument ? ((TileInstrument)reader.getBlockEntity(pos)).getColor() : -1, blocks.toArray(new Block[blocks.size()]));
    }

    protected static void registerIDyeableItemColors(RegisterColorHandlersEvent.Item event, List<? extends BlockItem> items) {
        event.getItemColors().register((stack, color) -> color > 0 ? -1 : DyeColor.byId((int)TagUtils.getIntOrDefault((DataComponentHolder)stack, AColoredBlock.DYE_ID.getName(), 0)).getFireworkColor(), (ItemLike[])items.toArray(new Item[items.size()]));
    }

    protected static void registerAColoredBlockColors(RegisterColorHandlersEvent.Block event, List<? extends AColoredBlock> blocks) {
        event.getBlockColors().register((state, reader, pos, color) -> reader != null && pos != null && state.getBlock() instanceof AColoredBlock ? AColoredBlock.getDecimalColorFromState(state) : -1, blocks.toArray(new Block[blocks.size()]));
    }
}

