/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.forge.common;

import io.github.tofodroid.mods.mimi.common.network.ClientMidiListPacket;
import io.github.tofodroid.mods.mimi.common.network.ClientMidiListPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ConfigurableMidiTileSyncPacket;
import io.github.tofodroid.mods.mimi.common.network.ConfigurableMidiTileSyncPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.EffectEmitterUpdatePacket;
import io.github.tofodroid.mods.mimi.common.network.EffectEmitterUpdatePacketHandler;
import io.github.tofodroid.mods.mimi.common.network.MIMIConfigPacket;
import io.github.tofodroid.mods.mimi.common.network.MIMIConfigPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.MidiDeviceBroadcastPacket;
import io.github.tofodroid.mods.mimi.common.network.MidiDeviceBroadcastPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.MultiNoteEventPacket;
import io.github.tofodroid.mods.mimi.common.network.MultiNoteEventPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ServerMidiUploadPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerMidiUploadPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerSongListPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerSongListPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerStatusPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerStatusPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ServerTimeSyncPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerTimeSyncPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.SyncInstrumentPacket;
import io.github.tofodroid.mods.mimi.common.network.SyncInstrumentPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.TransmitterControlPacket;
import io.github.tofodroid.mods.mimi.common.network.TransmitterControlPacketHandler;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

@Mod.EventBusSubscriber(modid="mimi", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NetworkManager {
    private static final Integer NET_PROTOCOL = 2;
    private static final SimpleChannel MOD_CHANNEL = ChannelBuilder.named((ResourceLocation)ResourceUtils.newModLocation("mod_channel")).networkProtocolVersion(NET_PROTOCOL.intValue()).simpleChannel();

    public static void sendToServer(Object message) {
        MOD_CHANNEL.send(message, PacketDistributor.SERVER.noArg());
    }

    public static void sendToPlayer(Object message, ServerPlayer player) {
        MOD_CHANNEL.send(message, PacketDistributor.PLAYER.with((Object)player));
    }

    public static void sendToPlayersInRange(Object message, BlockPos sourcePos, ServerLevel worldIn, ServerPlayer excludePlayer, Double range) {
        MOD_CHANNEL.send(message, NetworkManager.getPlayersInRangeTarget(sourcePos, worldIn, excludePlayer, range));
    }

    protected static PacketDistributor.PacketTarget getPlayersInRangeTarget(BlockPos targetPos, ServerLevel worldIn, ServerPlayer excludePlayer, Double range) {
        PacketDistributor.TargetPoint target = excludePlayer == null ? new PacketDistributor.TargetPoint((double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ(), range.doubleValue(), worldIn.dimension()) : new PacketDistributor.TargetPoint(excludePlayer, (double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ(), range.doubleValue(), worldIn.dimension());
        return PacketDistributor.NEAR.with((Object)target);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NetworkManager.registerMessage(NoteEventPacket.class, NoteEventPacket::encodePacket, NoteEventPacket::decodePacket, NetworkManager.createHandler(NoteEventPacketHandler::handlePacketClient, NoteEventPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(SyncInstrumentPacket.class, SyncInstrumentPacket::encodePacket, SyncInstrumentPacket::decodePacket, NetworkManager.createHandler(SyncInstrumentPacketHandler::handlePacketClient, SyncInstrumentPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(ClientMidiListPacket.class, ClientMidiListPacket::encodePacket, ClientMidiListPacket::decodePacket, NetworkManager.createHandler(ClientMidiListPacketHandler::handlePacketClient, ClientMidiListPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(ServerMusicPlayerStatusPacket.class, ServerMusicPlayerStatusPacket::encodePacket, ServerMusicPlayerStatusPacket::decodePacket, NetworkManager.createHandler(ServerMusicPlayerStatusPacketHandler::handlePacketClient, ServerMusicPlayerStatusPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(ServerMusicPlayerSongListPacket.class, ServerMusicPlayerSongListPacket::encodePacket, ServerMusicPlayerSongListPacket::decodePacket, NetworkManager.createHandler(ServerMusicPlayerSongListPacketHandler::handlePacketClient, ServerMusicPlayerSongListPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(ServerTimeSyncPacket.class, ServerTimeSyncPacket::encodePacket, ServerTimeSyncPacket::decodePacket, NetworkManager.createHandler(ServerTimeSyncPacketHandler::handlePacketClient, ServerTimeSyncPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(ConfigurableMidiTileSyncPacket.class, ConfigurableMidiTileSyncPacket::encodePacket, ConfigurableMidiTileSyncPacket::decodePacket, NetworkManager.createHandler(ConfigurableMidiTileSyncPacketHandler::handlePacketClient, ConfigurableMidiTileSyncPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(TransmitterControlPacket.class, TransmitterControlPacket::encodePacket, TransmitterControlPacket::decodePacket, NetworkManager.createHandler(TransmitterControlPacketHandler::handlePacketClient, TransmitterControlPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(ServerMidiUploadPacket.class, ServerMidiUploadPacket::encodePacket, ServerMidiUploadPacket::decodePacket, NetworkManager.createHandler(ServerMidiUploadPacketHandler::handlePacketClient, ServerMidiUploadPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(EffectEmitterUpdatePacket.class, EffectEmitterUpdatePacket::encodePacket, EffectEmitterUpdatePacket::decodePacket, NetworkManager.createHandler(EffectEmitterUpdatePacketHandler::handlePacketClient, EffectEmitterUpdatePacketHandler::handlePacketServer));
        NetworkManager.registerMessage(MultiNoteEventPacket.class, MultiNoteEventPacket::encodePacket, MultiNoteEventPacket::decodePacket, NetworkManager.createHandler(MultiNoteEventPacketHandler::handlePacketClient, MultiNoteEventPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(MidiDeviceBroadcastPacket.class, MidiDeviceBroadcastPacket::encodePacket, MidiDeviceBroadcastPacket::decodePacket, NetworkManager.createHandler(MidiDeviceBroadcastPacketHandler::handlePacketClient, MidiDeviceBroadcastPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(MIMIConfigPacket.class, MIMIConfigPacket::encodePacket, MIMIConfigPacket::decodePacket, NetworkManager.createHandler(MIMIConfigPacketHandler::handlePacketClient, MIMIConfigPacketHandler::handlePacketServer));
    }

    public static <T> void registerMessage(Class<T> messageClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, CustomPayloadEvent.Context> handler) {
        MOD_CHANNEL.messageBuilder(messageClass).encoder(encoder).decoder(decoder).consumerNetworkThread(handler).add();
    }

    public static <T> BiConsumer<T, CustomPayloadEvent.Context> createHandler(Consumer<T> handleClient, BiConsumer<T, ServerPlayer> handleServer) {
        return (message, ctx) -> {
            if (ctx.isServerSide()) {
                ctx.enqueueWork(() -> handleServer.accept(message, ctx.getSender()));
            } else {
                ctx.enqueueWork(() -> handleClient.accept(message));
            }
            ctx.setPacketHandled(true);
        };
    }
}

