/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.integration.jei;

import io.github.tofodroid.mods.mimi.client.gui.GuiInstrument;
import io.github.tofodroid.mods.mimi.client.gui.GuiTuningTableContainerScreen;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.recipe.ModRecipes;
import io.github.tofodroid.mods.mimi.common.recipe.TuningTableRecipe;
import io.github.tofodroid.mods.mimi.integration.jei.InstrumentGuiJEIHandler;
import io.github.tofodroid.mods.mimi.integration.jei.TuningTableRecipeCategory;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceUtils.newModLocation("jeiplugin");
    private static final Minecraft MC = Minecraft.getInstance();

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new TuningTableRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Objects.requireNonNull(JEIPlugin.MC.level).getRecipeManager();
        registration.addRecipes(TuningTableRecipeCategory.RECIPE_TYPE, manager.getRecipes().parallelStream().filter(recipe -> recipe.value().getType().equals(ModRecipes.TUNING_TYPE)).map(r -> (TuningTableRecipe)r.value()).collect(Collectors.toList()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.TUNINGTABLE), new RecipeType[]{TuningTableRecipeCategory.RECIPE_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GuiTuningTableContainerScreen.class, 102, 39, 22, 15, new RecipeType[]{TuningTableRecipeCategory.RECIPE_TYPE});
        registration.addGuiScreenHandler(GuiInstrument.class, (IScreenHandler)new InstrumentGuiJEIHandler());
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

