/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.mixin;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Parrot.class})
public abstract class ParrotMixin
extends Entity {
    @Shadow
    private BlockPos jukebox;
    @Shadow
    private boolean partyParrot;
    @Unique
    private Instant mimiNoteTime;

    public ParrotMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"setRecordPlayingNearby"}, at={@At(value="HEAD")})
    public void captureSet(BlockPos pos, boolean playing, CallbackInfo ci) {
        if (!this.level().getBlockState(pos).is(Blocks.JUKEBOX)) {
            this.mimiNoteTime = Instant.now();
        }
    }

    @Inject(method={"isPartyParrot"}, at={@At(value="RETURN")}, cancellable=true)
    private void isPartyParrotMimi(CallbackInfoReturnable<Boolean> cir) {
        this.mimiNoteTime = this.mimiNoteTime != null && Math.abs(ChronoUnit.SECONDS.between(Instant.now(), this.mimiNoteTime)) < 1L ? this.mimiNoteTime : null;
        cir.setReturnValue((Object)((Boolean)cir.getReturnValue() != false || this.mimiNoteTime != null ? 1 : 0));
    }
}

