/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.events.broadcast;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastConsumerInventoryHolder;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.IBroadcastConsumer;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.IBroadcastProducer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class BroadcastManager {
    protected static final HashMap<UUID, IBroadcastProducer> OWNED_PRODUCERS = new HashMap();
    protected static final HashMap<UUID, BroadcastConsumerInventoryHolder> OWNED_CONSUMERS = new HashMap();
    protected static final HashMap<UUID, List<IBroadcastConsumer>> LINKED_CONSUMERS = new HashMap();

    public static <T extends IBroadcastProducer> T registerProducer(T producer) {
        OWNED_PRODUCERS.computeIfAbsent(producer.getOwnerId(), id -> producer).linkConsumers(LINKED_CONSUMERS.computeIfAbsent(producer.getOwnerId(), id -> new ArrayList()));
        return producer;
    }

    public static IBroadcastProducer getBroadcastProducer(UUID producerId) {
        return OWNED_PRODUCERS.get(producerId);
    }

    public static void removeBroadcastProducer(UUID producerId) {
        IBroadcastProducer producer = OWNED_PRODUCERS.remove(producerId);
        if (producer != null) {
            try {
                producer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T extends IBroadcastProducer> List<T> getBroadcastProducersByType(Class<T> clazz) {
        ArrayList<IBroadcastProducer> result = new ArrayList<IBroadcastProducer>();
        for (IBroadcastProducer producer : OWNED_PRODUCERS.values()) {
            if (!producer.getClass().equals(clazz)) continue;
            result.add(producer);
        }
        return result;
    }

    private static void clearProducers() {
        for (IBroadcastProducer producer : OWNED_PRODUCERS.values()) {
            try {
                producer.close();
            }
            catch (Exception exception) {}
        }
        OWNED_PRODUCERS.clear();
    }

    public static void registerConsumers(BroadcastConsumerInventoryHolder holder) {
        BroadcastConsumerInventoryHolder existing = OWNED_CONSUMERS.get(holder.getOwnerId());
        if (existing != null && !existing.isEmpty().booleanValue()) {
            MIMIMod.LOGGER.warn("Attempted to register new consumers for owner ID that already has non-closed consumers: " + String.valueOf(holder.getOwnerId()));
            return;
        }
        if (!holder.isEmpty().booleanValue()) {
            OWNED_CONSUMERS.put(holder.getOwnerId(), holder);
            for (IBroadcastConsumer consumer : holder.getConsumers()) {
                LINKED_CONSUMERS.computeIfAbsent(consumer.getLinkedId(), id -> new ArrayList()).add(consumer);
                IBroadcastProducer linkedProducer = OWNED_PRODUCERS.get(consumer.getLinkedId());
                if (linkedProducer == null) continue;
                linkedProducer.reindex();
            }
        }
    }

    public static BroadcastConsumerInventoryHolder getOwnedBroadcastConsumers(UUID ownerId) {
        return OWNED_CONSUMERS.get(ownerId);
    }

    public static void removeOwnedBroadcastConsumers(UUID ownerId) {
        BroadcastConsumerInventoryHolder removedConsumers = OWNED_CONSUMERS.remove(ownerId);
        if (removedConsumers != null) {
            for (IBroadcastConsumer consumer : removedConsumers.getConsumers()) {
                if (consumer.getLinkedId() != null) {
                    IBroadcastProducer linkedProducer;
                    List<IBroadcastConsumer> linkedConsumerList = LINKED_CONSUMERS.get(consumer.getLinkedId());
                    if (linkedConsumerList != null) {
                        linkedConsumerList.remove(consumer);
                    }
                    if ((linkedProducer = OWNED_PRODUCERS.get(consumer.getLinkedId())) != null) {
                        linkedProducer.reindex();
                    }
                }
                consumer.onConsumerRemoved();
            }
        }
    }

    private static void clearConsumers() {
        for (BroadcastConsumerInventoryHolder holder : OWNED_CONSUMERS.values()) {
            for (IBroadcastConsumer consumer : holder.getConsumers()) {
                consumer.onConsumerRemoved();
            }
        }
        OWNED_CONSUMERS.clear();
    }

    public static void onServerTick() {
        for (IBroadcastProducer producer : OWNED_PRODUCERS.values()) {
            producer.tickProducer();
        }
        for (BroadcastConsumerInventoryHolder holder : OWNED_CONSUMERS.values()) {
            for (IBroadcastConsumer consumer : holder.getConsumers()) {
                consumer.tickConsumer();
            }
        }
    }

    public static void onServerStopping() {
        BroadcastManager.clearProducers();
        BroadcastManager.clearConsumers();
    }
}

