/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.events.broadcast.consumer.instrument;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.server.events.broadcast.api.AServerBroadcastConsumer;
import io.github.tofodroid.mods.mimi.server.events.note.consumer.ServerNoteConsumerManager;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class InstrumentBroadcastConsumer
extends AServerBroadcastConsumer {
    protected Byte instrumentId;
    protected Byte volume;
    protected InteractionHand handIn;

    public InstrumentBroadcastConsumer(Supplier<BlockPos> pos, Supplier<ResourceKey<Level>> dimension, UUID notePlayerId, ItemStack instrumentStack, InteractionHand handIn) {
        super(notePlayerId, MidiNbtDataUtils.getMidiSource(instrumentStack), MidiNbtDataUtils.getEnabledChannelsInt(instrumentStack), MidiNbtDataUtils.getEnabledChannelsList(instrumentStack), pos, dimension);
        this.instrumentId = MidiNbtDataUtils.getInstrumentId(instrumentStack);
        this.volume = MidiNbtDataUtils.getInstrumentVolume(instrumentStack);
        this.handIn = handIn;
    }

    public InstrumentBroadcastConsumer(BlockPos pos, ResourceKey<Level> dimension, UUID notePlayerId, ItemStack instrumentStack, InteractionHand handIn) {
        this(() -> pos, () -> dimension, notePlayerId, instrumentStack, handIn);
    }

    @Override
    public Boolean willHandleEvent(BroadcastEvent message) {
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof InstrumentBroadcastConsumer) {
            InstrumentBroadcastConsumer o = (InstrumentBroadcastConsumer)other;
            return o.linkedId.equals(this.linkedId) && o.instrumentId == this.instrumentId && o.enabledChannels == this.enabledChannels && o.volume == this.volume;
        }
        return false;
    }

    @Override
    public void doHandleEvent(BroadcastEvent message) {
        switch (message.type) {
            case NOTE_ON: {
                ServerNoteConsumerManager.handleEvent(new NoteEvent(MidiEventType.NOTE_ON, false, this.instrumentId, this.handIn, message.note, MidiNbtDataUtils.applyVolume(this.volume, message.velocity), this.ownerId, this.getConsumeDimension(), this.getConsumePos(), message.eventTime));
                break;
            }
            case NOTE_OFF: {
                ServerNoteConsumerManager.handleEvent(new NoteEvent(MidiEventType.NOTE_OFF, false, this.instrumentId, this.handIn, message.note, ByteUtils.ZERO, this.ownerId, this.getConsumeDimension(), this.getConsumePos(), message.eventTime));
                break;
            }
            case CONTROL: {
                ServerNoteConsumerManager.handleEvent(new NoteEvent(MidiEventType.CONTROL, false, this.instrumentId, this.handIn, message.note, message.velocity, this.ownerId, this.getConsumeDimension(), this.getConsumePos(), message.eventTime));
                break;
            }
            case RESET: {
                this.sendReset();
            }
            case PITCH_BEND: {
                ServerNoteConsumerManager.handleEvent(new NoteEvent(MidiEventType.PITCH_BEND, false, this.instrumentId, this.handIn, message.note, message.velocity, this.ownerId, this.getConsumeDimension(), this.getConsumePos(), message.eventTime));
                break;
            }
        }
    }

    @Override
    public void onConsumerRemoved() {
        this.sendReset();
    }

    public void sendReset() {
        ServerNoteConsumerManager.handleEvent(NoteEvent.reset(this.instrumentId, this.handIn, this.linkedId, this.getConsumeDimension(), this.getConsumePos(), MIMIMod.getProxy().getCurrentServerMillis()));
    }
}

