/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.events.note.consumer;

import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.common.network.MultiNoteEventPacket;
import io.github.tofodroid.mods.mimi.common.network.NetMidiEvent;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.server.events.note.api.ANoteConsumer;
import io.github.tofodroid.mods.mimi.util.EntityUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class PlayerNoteConsumer
extends ANoteConsumer {
    private ServerPlayer player;
    private Map<Long, ArrayList<NetMidiEvent>> packetCacheMap = new Long2ObjectOpenHashMap();
    private BlockPos cachedPos;
    private ResourceKey<Level> cachedDimension;

    public PlayerNoteConsumer(ServerPlayer player) {
        super(player.getUUID(), ALL_INSTRUMENTS_ID);
        this.player = player;
        this.cachedPos = EntityUtils.getEntityHeadPos((LivingEntity)this.player);
        this.cachedDimension = this.player.level().dimension();
    }

    protected Boolean wasSentBySelf(NoteEvent event) {
        return event.clientSource != false && event.senderId != null && this.player.getUUID().equals(event.senderId);
    }

    @Override
    public Boolean willHandleEvent(NoteEvent message) {
        return this.wasSentBySelf(message) == false;
    }

    @Override
    public void doHandleEvent(NoteEvent message) {
        this.cacheEvent(message);
    }

    protected Boolean playerIsAlive() {
        return this.player != null && !this.player.isRemoved() && !this.player.isDeadOrDying();
    }

    @Override
    public void tickConsumer() {
        if (!this.packetCacheMap.isEmpty() && this.playerIsAlive().booleanValue()) {
            NetworkProxy.sendToPlayer(new MultiNoteEventPacket(this.packetCacheMap), this.player);
            this.packetCacheMap.clear();
        }
        this.cachedPos = EntityUtils.getEntityHeadPos((LivingEntity)this.player);
        this.cachedDimension = this.player.level().dimension();
    }

    @Override
    public void onConsumerRemoved() {
    }

    private void cacheEvent(NoteEvent event) {
        if (event.senderId != null && event.pos != null && event.eventTime != null) {
            ArrayList<NetMidiEvent> eventList = this.packetCacheMap.getOrDefault(event.eventTime, new ArrayList());
            eventList.add(new NetMidiEvent(event));
            this.packetCacheMap.put(event.eventTime, eventList);
        }
    }

    @Override
    public BlockPos getBlockPos() {
        return this.cachedPos;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.cachedDimension;
    }
}

