/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.events.note.consumer;

import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.server.ServerExecutorProxy;
import it.unimi.dsi.fastutil.longs.Long2BooleanArrayMap;
import java.util.LinkedHashMap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class ServerNoteConsumer {
    private static final Integer CLEAR_EVENT_CACHE_EVERY_TICKS = 10;
    private static Integer eventCacheClearTickCounter = 0;
    private static final LinkedHashMap<ResourceKey<Level>, Long2BooleanArrayMap> EVENT_CACHE_MAP = new LinkedHashMap();

    public static void onServerTick() {
        if (eventCacheClearTickCounter >= CLEAR_EVENT_CACHE_EVERY_TICKS) {
            eventCacheClearTickCounter = 0;
            EVENT_CACHE_MAP.clear();
        } else {
            Integer n = eventCacheClearTickCounter;
            eventCacheClearTickCounter = eventCacheClearTickCounter + 1;
        }
    }

    public static void handleEvent(NoteEvent message) {
        ServerLevel worldIn = ServerExecutorProxy.getLevel((ResourceKey<Level>)message.dimension);
        Long2BooleanArrayMap eventMap = EVENT_CACHE_MAP.computeIfAbsent((ResourceKey<Level>)worldIn.dimension(), d -> new Long2BooleanArrayMap());
        if (message.type == MidiEventType.NOTE_ON) {
            eventMap.computeIfAbsent(message.pos.asLong(), key -> {
                if (worldIn.isLoaded(message.pos)) {
                    worldIn.gameEvent((Holder)GameEvent.INSTRUMENT_PLAY, message.pos, GameEvent.Context.of((BlockState)worldIn.getBlockState(message.pos)));
                    worldIn.gameEvent((Holder)GameEvent.JUKEBOX_PLAY, message.pos, GameEvent.Context.of((BlockState)worldIn.getBlockState(message.pos)));
                    worldIn.levelEvent(null, NoteEvent.MIMI_NOTE_PLAYING_LEVEL_EVENT_ID.intValue(), message.pos, (int)message.note.byteValue());
                }
                return true;
            });
        }
    }
}

